/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.engine.cedrusdata;

import java.util.Map;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import ru.cedrusdata.catalog.engine.cedrusdata.AbstractCatalogCedrusDataOperation;
import ru.cedrusdata.catalog.spi.computeengine.CatalogTable;

public class CatalogCedrusDataOptimizeOperation
extends AbstractCatalogCedrusDataOperation {
    private final long fileSizeThresholdBytes;
    private final String whereClause;

    public CatalogCedrusDataOptimizeOperation(Jdbi jdbi, CatalogTable table, long fileSizeThresholdBytes, String whereClause) {
        super(jdbi, table);
        this.fileSizeThresholdBytes = fileSizeThresholdBytes;
        this.whereClause = whereClause;
    }

    @Override
    protected Map<String, String> execute(Handle handle, String catalogName, String fullTableName) {
        Object sql = String.format("ALTER TABLE %s EXECUTE optimize(file_size_threshold => '%sB')", fullTableName, this.fileSizeThresholdBytes);
        if (this.whereClause != null) {
            sql = (String)sql + " WHERE " + this.whereClause;
        }
        return CatalogCedrusDataOptimizeOperation.jsonToMap(handle.createQuery((String)sql).mapTo(String.class).findOne());
    }
}

