/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.engine.cedrusdata;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.cedrusdata.catalog.spi.CatalogResourceResolver;

public class CatalogCedrusDataEngineConfig {
    private static final Pattern RESOURCE_PARAMETER_PATTERN = Pattern.compile("([a-zA-Z0-9_-]*)=\\$\\{resource:([^}]+?)}");
    private static final int DEFAULT_CONNECTION_POOL_SIZE = 100;
    private String jdbcUrl;
    private int connectionPoolSize = 100;

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    @Config(value="jdbcUrl")
    @ConfigDescription(value="JDBC connection URL. If connection parameter refers to a file from the catalog resource directory, then file name must be specified in the format ${resource:<file name>}")
    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    @Config(value="connectionPoolSize")
    @ConfigDescription(value="Maximum size of the JDBC connection pool")
    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public static Optional<String> validateProperties(Map<String, String> mutableConfig, CatalogResourceResolver resourceResolver) {
        String[] requiredProperties;
        for (String requiredProperty : requiredProperties = new String[]{"jdbcUrl"}) {
            String property = mutableConfig.get(requiredProperty);
            if (property != null && !property.isEmpty()) continue;
            return Optional.of(String.format("\"%s\" cannot be empty", requiredProperty));
        }
        HashMap<String, String> unusedConfig = new HashMap<String, String>(mutableConfig);
        for (Method method : CatalogCedrusDataEngineConfig.class.getMethods()) {
            Config configAnnotation = method.getAnnotation(Config.class);
            if (configAnnotation == null) continue;
            unusedConfig.remove(configAnnotation.value());
        }
        if (!unusedConfig.isEmpty()) {
            return Optional.of(String.format("Unsupported property: \"%s\"", unusedConfig.keySet().iterator().next()));
        }
        if (mutableConfig.containsKey("connectionPoolSize")) {
            int connectionPoolSize;
            try {
                connectionPoolSize = Integer.parseInt(mutableConfig.get("connectionPoolSize"));
            }
            catch (NumberFormatException e) {
                return Optional.of(String.format("Cannot parse \"connectionPoolSize\" parameter: %s", mutableConfig.get("connectionPoolSize")));
            }
            if (connectionPoolSize < 1) {
                return Optional.of("\"connectionPoolSize\" cannot be less than 1");
            }
        }
        mutableConfig.put("jdbcUrl", CatalogCedrusDataEngineConfig.resolveResources(mutableConfig.get("jdbcUrl"), resourceResolver));
        return Optional.empty();
    }

    private static String resolveResources(String jdbcUrl, CatalogResourceResolver resourceResolver) {
        StringBuilder replacedUrl = new StringBuilder();
        Matcher matcher = RESOURCE_PARAMETER_PATTERN.matcher(jdbcUrl);
        while (matcher.find()) {
            String parameterName = matcher.group(1);
            String resource = matcher.group(2);
            matcher.appendReplacement(replacedUrl, Matcher.quoteReplacement(parameterName + "=" + resourceResolver.resolveResourcePath(resource, parameterName)));
        }
        matcher.appendTail(replacedUrl);
        return replacedUrl.toString();
    }
}

