/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.engine.cedrusdata;

import io.airlift.json.JsonCodec;
import java.sql.SQLClientInfoException;
import java.util.Map;
import java.util.Optional;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.result.ResultSetException;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperation;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationContext;
import ru.cedrusdata.catalog.spi.computeengine.CatalogTable;

public abstract class AbstractCatalogCedrusDataOperation
implements CatalogComputeEngineOperation {
    protected static final JsonCodec<Map<String, String>> RESULT_CODEC = JsonCodec.mapJsonCodec(String.class, String.class);
    private final Jdbi jdbi;
    protected final CatalogTable table;

    public AbstractCatalogCedrusDataOperation(Jdbi jdbi, CatalogTable table) {
        this.jdbi = jdbi;
        this.table = table;
    }

    protected abstract Map<String, String> execute(Handle var1, String var2, String var3);

    public final Map<String, String> execute(CatalogComputeEngineOperationContext operationContext) {
        Map<String, String> map;
        block10: {
            Handle handle = this.jdbi.open();
            try {
                handle.getConnection().setClientInfo("TraceToken", operationContext.operationId().toString());
                String catalogName = operationContext.engineConfig().getOrDefault("catalog", this.table.catalog());
                String fullTableName = String.format("%s.%s.%s", catalogName, this.table.namespace(), this.table.tableName());
                map = this.execute(handle, catalogName, fullTableName);
                if (handle == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (handle != null) {
                        try {
                            handle.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ResultSetException e) {
                    if (e.getCause() != null) {
                        throw new RuntimeException(e.getCause());
                    }
                    throw e;
                }
                catch (SQLClientInfoException e) {
                    throw new RuntimeException(e);
                }
            }
            handle.close();
        }
        return map;
    }

    protected static Map<String, String> jsonToMap(Optional<String> json) {
        return json.map(arg_0 -> RESULT_CODEC.fromJson(arg_0)).orElse(Map.of());
    }
}

