/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.Securable;

@JsonTypeName(value="PrivilegeGrantInfo")
public class PrivilegeGrantInfo {
    private final String granteeName;
    private final String privilege;
    private final Securable securable;

    @JsonCreator
    public PrivilegeGrantInfo(@JsonProperty(value="grantee-name") String granteeName, @JsonProperty(value="privilege") String privilege, @JsonProperty(value="securable") Securable securable) {
        this.granteeName = granteeName;
        this.privilege = privilege;
        this.securable = securable;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="grantee-name")
    public String getGranteeName() {
        return this.granteeName;
    }

    @JsonProperty(value="privilege")
    public String getPrivilege() {
        return this.privilege;
    }

    @JsonProperty(value="securable")
    public Securable getSecurable() {
        return this.securable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegeGrantInfo privilegeGrantInfo = (PrivilegeGrantInfo)o;
        return Objects.equals(this.granteeName, privilegeGrantInfo.granteeName) && Objects.equals(this.privilege, privilegeGrantInfo.privilege) && Objects.equals(this.securable, privilegeGrantInfo.securable);
    }

    public int hashCode() {
        return Objects.hash(this.granteeName, this.privilege, this.securable);
    }

    public String toString() {
        return "PrivilegeGrantInfo{granteeName='" + this.granteeName + "', privilege='" + this.privilege + "', securable='" + String.valueOf(this.securable) + "'}";
    }

    public static class Builder {
        private String granteeName;
        private String privilege;
        private Securable securable;

        private Builder() {
        }

        public Builder setGranteeName(String granteeName) {
            this.granteeName = granteeName;
            return this;
        }

        public Builder setPrivilege(String privilege) {
            this.privilege = privilege;
            return this;
        }

        public Builder setSecurable(Securable securable) {
            this.securable = securable;
            return this;
        }

        public PrivilegeGrantInfo build() {
            return new PrivilegeGrantInfo(this.granteeName, this.privilege, this.securable);
        }
    }
}

