/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.StringValue;

@JsonTypeName(value="ObjectGroupUpdateRequest")
public class ObjectGroupUpdateRequest {
    private final StringValue groupName;
    private final StringValue description;

    @JsonCreator
    public ObjectGroupUpdateRequest(@JsonProperty(value="group-name") StringValue groupName, @JsonProperty(value="description") StringValue description) {
        this.groupName = groupName;
        this.description = description;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="group-name")
    public StringValue getGroupName() {
        return this.groupName;
    }

    @JsonProperty(value="description")
    public StringValue getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectGroupUpdateRequest objectGroupUpdateRequest = (ObjectGroupUpdateRequest)o;
        return Objects.equals(this.groupName, objectGroupUpdateRequest.groupName) && Objects.equals(this.description, objectGroupUpdateRequest.description);
    }

    public int hashCode() {
        return Objects.hash(this.groupName, this.description);
    }

    public String toString() {
        return "ObjectGroupUpdateRequest{groupName='" + String.valueOf(this.groupName) + "', description='" + String.valueOf(this.description) + "'}";
    }

    public static class Builder {
        private StringValue groupName;
        private StringValue description;

        private Builder() {
        }

        public Builder setGroupName(StringValue groupName) {
            this.groupName = groupName;
            return this;
        }

        public Builder setDescription(StringValue description) {
            this.description = description;
            return this;
        }

        public ObjectGroupUpdateRequest build() {
            return new ObjectGroupUpdateRequest(this.groupName, this.description);
        }
    }
}

