/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.ObjectGroupInfo;

@JsonTypeName(value="ObjectGroupListResponse")
public class ObjectGroupListResponse {
    private final List<ObjectGroupInfo> items;
    private final String nextPageToken;

    @JsonCreator
    public ObjectGroupListResponse(@JsonProperty(value="items") List<ObjectGroupInfo> items, @JsonProperty(value="next-page-token") String nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="items")
    public List<ObjectGroupInfo> getItems() {
        return this.items;
    }

    @JsonProperty(value="next-page-token")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectGroupListResponse objectGroupListResponse = (ObjectGroupListResponse)o;
        return Objects.equals(this.items, objectGroupListResponse.items) && Objects.equals(this.nextPageToken, objectGroupListResponse.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPageToken);
    }

    public String toString() {
        return "ObjectGroupListResponse{items='" + String.valueOf(this.items) + "', nextPageToken='" + this.nextPageToken + "'}";
    }

    public static class Builder {
        private List<ObjectGroupInfo> items;
        private String nextPageToken;

        private Builder() {
        }

        public Builder setItems(List<ObjectGroupInfo> items) {
            this.items = items;
            return this;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public ObjectGroupListResponse build() {
            return new ObjectGroupListResponse(this.items, this.nextPageToken);
        }
    }
}

