/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.StringValue;

@JsonTypeName(value="MaintenanceJobUpdateRequest")
public class MaintenanceJobUpdateRequest {
    private final StringValue newJobName;
    private final StringValue scheduleExpression;
    private final StringValue scheduleTimeZoneId;
    private final StringValue targetObjectGroupName;
    private final StringValue runAs;
    private final StringValue description;

    @JsonCreator
    public MaintenanceJobUpdateRequest(@JsonProperty(value="new-job-name") StringValue newJobName, @JsonProperty(value="schedule-expression") StringValue scheduleExpression, @JsonProperty(value="schedule-time-zone-id") StringValue scheduleTimeZoneId, @JsonProperty(value="target-object-group-name") StringValue targetObjectGroupName, @JsonProperty(value="run-as") StringValue runAs, @JsonProperty(value="description") StringValue description) {
        this.newJobName = newJobName;
        this.scheduleExpression = scheduleExpression;
        this.scheduleTimeZoneId = scheduleTimeZoneId;
        this.targetObjectGroupName = targetObjectGroupName;
        this.runAs = runAs;
        this.description = description;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="new-job-name")
    public StringValue getNewJobName() {
        return this.newJobName;
    }

    @JsonProperty(value="schedule-expression")
    public StringValue getScheduleExpression() {
        return this.scheduleExpression;
    }

    @JsonProperty(value="schedule-time-zone-id")
    public StringValue getScheduleTimeZoneId() {
        return this.scheduleTimeZoneId;
    }

    @JsonProperty(value="target-object-group-name")
    public StringValue getTargetObjectGroupName() {
        return this.targetObjectGroupName;
    }

    @JsonProperty(value="run-as")
    public StringValue getRunAs() {
        return this.runAs;
    }

    @JsonProperty(value="description")
    public StringValue getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaintenanceJobUpdateRequest maintenanceJobUpdateRequest = (MaintenanceJobUpdateRequest)o;
        return Objects.equals(this.newJobName, maintenanceJobUpdateRequest.newJobName) && Objects.equals(this.scheduleExpression, maintenanceJobUpdateRequest.scheduleExpression) && Objects.equals(this.scheduleTimeZoneId, maintenanceJobUpdateRequest.scheduleTimeZoneId) && Objects.equals(this.targetObjectGroupName, maintenanceJobUpdateRequest.targetObjectGroupName) && Objects.equals(this.runAs, maintenanceJobUpdateRequest.runAs) && Objects.equals(this.description, maintenanceJobUpdateRequest.description);
    }

    public int hashCode() {
        return Objects.hash(this.newJobName, this.scheduleExpression, this.scheduleTimeZoneId, this.targetObjectGroupName, this.runAs, this.description);
    }

    public String toString() {
        return "MaintenanceJobUpdateRequest{newJobName='" + String.valueOf(this.newJobName) + "', scheduleExpression='" + String.valueOf(this.scheduleExpression) + "', scheduleTimeZoneId='" + String.valueOf(this.scheduleTimeZoneId) + "', targetObjectGroupName='" + String.valueOf(this.targetObjectGroupName) + "', runAs='" + String.valueOf(this.runAs) + "', description='" + String.valueOf(this.description) + "'}";
    }

    public static class Builder {
        private StringValue newJobName;
        private StringValue scheduleExpression;
        private StringValue scheduleTimeZoneId;
        private StringValue targetObjectGroupName;
        private StringValue runAs;
        private StringValue description;

        private Builder() {
        }

        public Builder setNewJobName(StringValue newJobName) {
            this.newJobName = newJobName;
            return this;
        }

        public Builder setScheduleExpression(StringValue scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public Builder setScheduleTimeZoneId(StringValue scheduleTimeZoneId) {
            this.scheduleTimeZoneId = scheduleTimeZoneId;
            return this;
        }

        public Builder setTargetObjectGroupName(StringValue targetObjectGroupName) {
            this.targetObjectGroupName = targetObjectGroupName;
            return this;
        }

        public Builder setRunAs(StringValue runAs) {
            this.runAs = runAs;
            return this;
        }

        public Builder setDescription(StringValue description) {
            this.description = description;
            return this;
        }

        public MaintenanceJobUpdateRequest build() {
            return new MaintenanceJobUpdateRequest(this.newJobName, this.scheduleExpression, this.scheduleTimeZoneId, this.targetObjectGroupName, this.runAs, this.description);
        }
    }
}

