/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.JobScheduleConfig;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationConfig;

@JsonTypeName(value="MaintenanceJobInfo")
public class MaintenanceJobInfo {
    private final String jobName;
    private final MaintenanceOperationConfig operationConfig;
    private final JobScheduleConfig scheduleConfig;
    private final String targetObjectGroupName;
    private final String owner;
    private final String runAs;
    private final String description;
    private final Long lastExecutionAt;
    private final Long nextExecutionAt;

    @JsonCreator
    public MaintenanceJobInfo(@JsonProperty(value="job-name") String jobName, @JsonProperty(value="operation-config") MaintenanceOperationConfig operationConfig, @JsonProperty(value="schedule-config") JobScheduleConfig scheduleConfig, @JsonProperty(value="target-object-group-name") String targetObjectGroupName, @JsonProperty(value="owner") String owner, @JsonProperty(value="runAs") String runAs, @JsonProperty(value="description") String description, @JsonProperty(value="last-execution-at") Long lastExecutionAt, @JsonProperty(value="next-execution-at") Long nextExecutionAt) {
        this.jobName = jobName;
        this.operationConfig = operationConfig;
        this.scheduleConfig = scheduleConfig;
        this.targetObjectGroupName = targetObjectGroupName;
        this.owner = owner;
        this.runAs = runAs;
        this.description = description;
        this.lastExecutionAt = lastExecutionAt;
        this.nextExecutionAt = nextExecutionAt;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="job-name")
    public String getJobName() {
        return this.jobName;
    }

    @JsonProperty(value="operation-config")
    public MaintenanceOperationConfig getOperationConfig() {
        return this.operationConfig;
    }

    @JsonProperty(value="schedule-config")
    public JobScheduleConfig getScheduleConfig() {
        return this.scheduleConfig;
    }

    @JsonProperty(value="target-object-group-name")
    public String getTargetObjectGroupName() {
        return this.targetObjectGroupName;
    }

    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="runAs")
    public String getRunAs() {
        return this.runAs;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="last-execution-at")
    public Long getLastExecutionAt() {
        return this.lastExecutionAt;
    }

    @JsonProperty(value="next-execution-at")
    public Long getNextExecutionAt() {
        return this.nextExecutionAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaintenanceJobInfo maintenanceJobInfo = (MaintenanceJobInfo)o;
        return Objects.equals(this.jobName, maintenanceJobInfo.jobName) && Objects.equals(this.operationConfig, maintenanceJobInfo.operationConfig) && Objects.equals(this.scheduleConfig, maintenanceJobInfo.scheduleConfig) && Objects.equals(this.targetObjectGroupName, maintenanceJobInfo.targetObjectGroupName) && Objects.equals(this.owner, maintenanceJobInfo.owner) && Objects.equals(this.runAs, maintenanceJobInfo.runAs) && Objects.equals(this.description, maintenanceJobInfo.description) && Objects.equals(this.lastExecutionAt, maintenanceJobInfo.lastExecutionAt) && Objects.equals(this.nextExecutionAt, maintenanceJobInfo.nextExecutionAt);
    }

    public int hashCode() {
        return Objects.hash(this.jobName, this.operationConfig, this.scheduleConfig, this.targetObjectGroupName, this.owner, this.runAs, this.description, this.lastExecutionAt, this.nextExecutionAt);
    }

    public String toString() {
        return "MaintenanceJobInfo{jobName='" + this.jobName + "', operationConfig='" + String.valueOf(this.operationConfig) + "', scheduleConfig='" + String.valueOf(this.scheduleConfig) + "', targetObjectGroupName='" + this.targetObjectGroupName + "', owner='" + this.owner + "', runAs='" + this.runAs + "', description='" + this.description + "', lastExecutionAt='" + this.lastExecutionAt + "', nextExecutionAt='" + this.nextExecutionAt + "'}";
    }

    public static class Builder {
        private String jobName;
        private MaintenanceOperationConfig operationConfig;
        private JobScheduleConfig scheduleConfig;
        private String targetObjectGroupName;
        private String owner;
        private String runAs;
        private String description;
        private Long lastExecutionAt;
        private Long nextExecutionAt;

        private Builder() {
        }

        public Builder setJobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder setOperationConfig(MaintenanceOperationConfig operationConfig) {
            this.operationConfig = operationConfig;
            return this;
        }

        public Builder setScheduleConfig(JobScheduleConfig scheduleConfig) {
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        public Builder setTargetObjectGroupName(String targetObjectGroupName) {
            this.targetObjectGroupName = targetObjectGroupName;
            return this;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder setRunAs(String runAs) {
            this.runAs = runAs;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setLastExecutionAt(Long lastExecutionAt) {
            this.lastExecutionAt = lastExecutionAt;
            return this;
        }

        public Builder setNextExecutionAt(Long nextExecutionAt) {
            this.nextExecutionAt = nextExecutionAt;
            return this;
        }

        public MaintenanceJobInfo build() {
            return new MaintenanceJobInfo(this.jobName, this.operationConfig, this.scheduleConfig, this.targetObjectGroupName, this.owner, this.runAs, this.description, this.lastExecutionAt, this.nextExecutionAt);
        }
    }
}

