/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;

@JsonTypeName(value="IcebergNamespaceInfo")
public class IcebergNamespaceInfo {
    private final String catalogName;
    private final String namespaceName;
    private final String owner;
    private final Map<String, String> properties;

    @JsonCreator
    public IcebergNamespaceInfo(@JsonProperty(value="catalog-name") String catalogName, @JsonProperty(value="namespace-name") String namespaceName, @JsonProperty(value="owner") String owner, @JsonProperty(value="properties") Map<String, String> properties) {
        this.catalogName = catalogName;
        this.namespaceName = namespaceName;
        this.owner = owner;
        this.properties = properties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="catalog-name")
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="namespace-name")
    public String getNamespaceName() {
        return this.namespaceName;
    }

    @JsonProperty(value="owner")
    public String getOwner() {
        return this.owner;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergNamespaceInfo icebergNamespaceInfo = (IcebergNamespaceInfo)o;
        return Objects.equals(this.catalogName, icebergNamespaceInfo.catalogName) && Objects.equals(this.namespaceName, icebergNamespaceInfo.namespaceName) && Objects.equals(this.owner, icebergNamespaceInfo.owner) && Objects.equals(this.properties, icebergNamespaceInfo.properties);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.namespaceName, this.owner, this.properties);
    }

    public String toString() {
        return "IcebergNamespaceInfo{catalogName='" + this.catalogName + "', namespaceName='" + this.namespaceName + "', owner='" + this.owner + "', properties='" + String.valueOf(this.properties) + "'}";
    }

    public static class Builder {
        private String catalogName;
        private String namespaceName;
        private String owner;
        private Map<String, String> properties;

        private Builder() {
        }

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public Builder setOwner(String owner) {
            this.owner = owner;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public IcebergNamespaceInfo build() {
            return new IcebergNamespaceInfo(this.catalogName, this.namespaceName, this.owner, this.properties);
        }
    }
}

