/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogInfo;

@JsonTypeName(value="IcebergCatalogListResponse")
public class IcebergCatalogListResponse {
    private final List<IcebergCatalogInfo> items;
    private final String nextPageToken;

    @JsonCreator
    public IcebergCatalogListResponse(@JsonProperty(value="items") List<IcebergCatalogInfo> items, @JsonProperty(value="next-page-token") String nextPageToken) {
        this.items = items;
        this.nextPageToken = nextPageToken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="items")
    public List<IcebergCatalogInfo> getItems() {
        return this.items;
    }

    @JsonProperty(value="next-page-token")
    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergCatalogListResponse icebergCatalogListResponse = (IcebergCatalogListResponse)o;
        return Objects.equals(this.items, icebergCatalogListResponse.items) && Objects.equals(this.nextPageToken, icebergCatalogListResponse.nextPageToken);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.nextPageToken);
    }

    public String toString() {
        return "IcebergCatalogListResponse{items='" + String.valueOf(this.items) + "', nextPageToken='" + this.nextPageToken + "'}";
    }

    public static class Builder {
        private List<IcebergCatalogInfo> items;
        private String nextPageToken;

        private Builder() {
        }

        public Builder setItems(List<IcebergCatalogInfo> items) {
            this.items = items;
            return this;
        }

        public Builder setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public IcebergCatalogListResponse build() {
            return new IcebergCatalogListResponse(this.items, this.nextPageToken);
        }
    }
}

