/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;

@JsonTypeName(value="IcebergCatalogCreateRequest")
public class IcebergCatalogCreateRequest {
    private final String catalogName;
    private final String description;
    private final String fileSystemName;
    private final String fileSystemLocation;
    private final Map<String, String> properties;

    @JsonCreator
    public IcebergCatalogCreateRequest(@JsonProperty(value="catalog-name") String catalogName, @JsonProperty(value="description") String description, @JsonProperty(value="file-system-name") String fileSystemName, @JsonProperty(value="file-system-location") String fileSystemLocation, @JsonProperty(value="properties") Map<String, String> properties) {
        this.catalogName = catalogName;
        this.description = description;
        this.fileSystemName = fileSystemName;
        this.fileSystemLocation = fileSystemLocation;
        this.properties = properties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="catalog-name")
    public String getCatalogName() {
        return this.catalogName;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="file-system-name")
    public String getFileSystemName() {
        return this.fileSystemName;
    }

    @JsonProperty(value="file-system-location")
    public String getFileSystemLocation() {
        return this.fileSystemLocation;
    }

    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcebergCatalogCreateRequest icebergCatalogCreateRequest = (IcebergCatalogCreateRequest)o;
        return Objects.equals(this.catalogName, icebergCatalogCreateRequest.catalogName) && Objects.equals(this.description, icebergCatalogCreateRequest.description) && Objects.equals(this.fileSystemName, icebergCatalogCreateRequest.fileSystemName) && Objects.equals(this.fileSystemLocation, icebergCatalogCreateRequest.fileSystemLocation) && Objects.equals(this.properties, icebergCatalogCreateRequest.properties);
    }

    public int hashCode() {
        return Objects.hash(this.catalogName, this.description, this.fileSystemName, this.fileSystemLocation, this.properties);
    }

    public String toString() {
        return "IcebergCatalogCreateRequest{catalogName='" + this.catalogName + "', description='" + this.description + "', fileSystemName='" + this.fileSystemName + "', fileSystemLocation='" + this.fileSystemLocation + "', properties='" + String.valueOf(this.properties) + "'}";
    }

    public static class Builder {
        private String catalogName;
        private String description;
        private String fileSystemName;
        private String fileSystemLocation;
        private Map<String, String> properties;

        private Builder() {
        }

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setFileSystemName(String fileSystemName) {
            this.fileSystemName = fileSystemName;
            return this;
        }

        public Builder setFileSystemLocation(String fileSystemLocation) {
            this.fileSystemLocation = fileSystemLocation;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public IcebergCatalogCreateRequest build() {
            return new IcebergCatalogCreateRequest(this.catalogName, this.description, this.fileSystemName, this.fileSystemLocation, this.properties);
        }
    }
}

