/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import ru.cedrusdata.catalog.spi.model.StringValue;

@JsonTypeName(value="ComputeEngineUpdateRequest")
public class ComputeEngineUpdateRequest {
    private final StringValue newEngineName;
    private final StringValue description;
    private final Map<String, String> updatedProperties;
    private final Set<String> removedProperties;

    @JsonCreator
    public ComputeEngineUpdateRequest(@JsonProperty(value="new-engine-name") StringValue newEngineName, @JsonProperty(value="description") StringValue description, @JsonProperty(value="updated-properties") Map<String, String> updatedProperties, @JsonProperty(value="removed-properties") Set<String> removedProperties) {
        this.newEngineName = newEngineName;
        this.description = description;
        this.updatedProperties = updatedProperties;
        this.removedProperties = removedProperties;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="new-engine-name")
    public StringValue getNewEngineName() {
        return this.newEngineName;
    }

    @JsonProperty(value="description")
    public StringValue getDescription() {
        return this.description;
    }

    @JsonProperty(value="updated-properties")
    public Map<String, String> getUpdatedProperties() {
        return this.updatedProperties;
    }

    @JsonProperty(value="removed-properties")
    public Set<String> getRemovedProperties() {
        return this.removedProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputeEngineUpdateRequest computeEngineUpdateRequest = (ComputeEngineUpdateRequest)o;
        return Objects.equals(this.newEngineName, computeEngineUpdateRequest.newEngineName) && Objects.equals(this.description, computeEngineUpdateRequest.description) && Objects.equals(this.updatedProperties, computeEngineUpdateRequest.updatedProperties) && Objects.equals(this.removedProperties, computeEngineUpdateRequest.removedProperties);
    }

    public int hashCode() {
        return Objects.hash(this.newEngineName, this.description, this.updatedProperties, this.removedProperties);
    }

    public String toString() {
        return "ComputeEngineUpdateRequest{newEngineName='" + String.valueOf(this.newEngineName) + "', description='" + String.valueOf(this.description) + "', updatedProperties='" + String.valueOf(this.updatedProperties) + "', removedProperties='" + String.valueOf(this.removedProperties) + "'}";
    }

    public static class Builder {
        private StringValue newEngineName;
        private StringValue description;
        private Map<String, String> updatedProperties;
        private Set<String> removedProperties;

        private Builder() {
        }

        public Builder setNewEngineName(StringValue newEngineName) {
            this.newEngineName = newEngineName;
            return this;
        }

        public Builder setDescription(StringValue description) {
            this.description = description;
            return this;
        }

        public Builder setUpdatedProperties(Map<String, String> updatedProperties) {
            this.updatedProperties = updatedProperties;
            return this;
        }

        public Builder setRemovedProperties(Set<String> removedProperties) {
            this.removedProperties = removedProperties;
            return this;
        }

        public ComputeEngineUpdateRequest build() {
            return new ComputeEngineUpdateRequest(this.newEngineName, this.description, this.updatedProperties, this.removedProperties);
        }
    }
}

