/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import ru.cedrusdata.catalog.spi.model.ComputeEngineOperationParameterMetadata;

@JsonTypeName(value="ComputeEngineOperationMetadata")
public class ComputeEngineOperationMetadata {
    private final String name;
    private final String description;
    private final String descriptionLabel;
    private final List<ComputeEngineOperationParameterMetadata> parameters;

    @JsonCreator
    public ComputeEngineOperationMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="description-label") String descriptionLabel, @JsonProperty(value="parameters") List<ComputeEngineOperationParameterMetadata> parameters) {
        this.name = name;
        this.description = description;
        this.descriptionLabel = descriptionLabel;
        this.parameters = parameters;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description-label")
    public String getDescriptionLabel() {
        return this.descriptionLabel;
    }

    @JsonProperty(value="parameters")
    public List<ComputeEngineOperationParameterMetadata> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComputeEngineOperationMetadata computeEngineOperationMetadata = (ComputeEngineOperationMetadata)o;
        return Objects.equals(this.name, computeEngineOperationMetadata.name) && Objects.equals(this.description, computeEngineOperationMetadata.description) && Objects.equals(this.descriptionLabel, computeEngineOperationMetadata.descriptionLabel) && Objects.equals(this.parameters, computeEngineOperationMetadata.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.descriptionLabel, this.parameters);
    }

    public String toString() {
        return "ComputeEngineOperationMetadata{name='" + this.name + "', description='" + this.description + "', descriptionLabel='" + this.descriptionLabel + "', parameters='" + String.valueOf(this.parameters) + "'}";
    }

    public static class Builder {
        private String name;
        private String description;
        private String descriptionLabel;
        private List<ComputeEngineOperationParameterMetadata> parameters;

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setDescriptionLabel(String descriptionLabel) {
            this.descriptionLabel = descriptionLabel;
            return this;
        }

        public Builder setParameters(List<ComputeEngineOperationParameterMetadata> parameters) {
            this.parameters = parameters;
            return this;
        }

        public ComputeEngineOperationMetadata build() {
            return new ComputeEngineOperationMetadata(this.name, this.description, this.descriptionLabel, this.parameters);
        }
    }
}

