/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.computeengine;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import ru.cedrusdata.catalog.spi.CatalogPluginContext;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngine;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineType;
import ru.cedrusdata.catalog.spi.model.ComputeEngineOperationMetadata;
import ru.cedrusdata.catalog.spi.model.ComputeEngineOperationParameterMetadata;
import ru.cedrusdata.catalog.spi.model.ComputeEngineOperationParameterType;

public interface CatalogComputeEngineProvider {
    public CatalogComputeEngineType getComputeEngineType();

    default public List<ComputeEngineOperationMetadata> supportedOperations() {
        return List.of();
    }

    default public Map<Locale, ResourceBundle> labels() {
        return Map.of();
    }

    public CatalogComputeEngine createComputeEngine(CatalogPluginContext var1, Map<String, String> var2);

    default public Set<String> redactedPropertyKeys() {
        return Set.of();
    }

    public static ComputeEngineOperationMetadata operationMetadata(ResourceBundle resourceBundle, String engineType, String operationName, Map<String, ComputeEngineOperationParameterType> parameterTypes) {
        List<ComputeEngineOperationParameterMetadata> parameters = parameterTypes.entrySet().stream().map(parameter -> {
            String parameterName = (String)parameter.getKey();
            String parameterDescriptionLabel = String.format("engine.%s.%s.parameter.%s.description", engineType, operationName, parameterName);
            return ComputeEngineOperationParameterMetadata.newBuilder().setName(parameterName).setType((ComputeEngineOperationParameterType)((Object)((Object)parameter.getValue()))).setDescription(resourceBundle.getString(parameterDescriptionLabel)).setDescriptionLabel(parameterDescriptionLabel).build();
        }).toList();
        String operationDescriptionLabel = String.format("engine.%s.%s.description", engineType, operationName);
        return ComputeEngineOperationMetadata.newBuilder().setName(operationName).setDescription(resourceBundle.getString(operationDescriptionLabel)).setDescriptionLabel(operationDescriptionLabel).setParameters(parameters).build();
    }
}

