/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.computeengine;

import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperation;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineOperationObjectType;
import ru.cedrusdata.catalog.spi.computeengine.CatalogTable;
import ru.cedrusdata.catalog.spi.computeengine.result.ComputeEngineResultAggregator;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;

public interface CatalogComputeEngineOperationFactory {
    public String name();

    public Set<CatalogComputeEngineOperationObjectType> supportedObjectTypes();

    public boolean loadTable();

    public CatalogComputeEngineOperation createTableOperation(CatalogTable var1);

    public ComputeEngineResultAggregator createResultAggregator();

    public static int parsePositiveIntegerParameter(Map<String, String> params, String paramName, int defaultValue) {
        int value = defaultValue;
        String stringValue = params.get(paramName);
        if (stringValue != null) {
            try {
                value = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                throw new CatalogBadRequestException(String.format("Cannot parse \"%s\" parameter: %s", paramName, stringValue));
            }
        }
        if (value < 1) {
            throw new CatalogBadRequestException(String.format("Parameter \"%s\" must be positive: %s", paramName, value));
        }
        return value;
    }

    public static long parsePositiveLongParameter(Map<String, String> params, String paramName, long defaultValue) {
        long value = defaultValue;
        String stringValue = params.get(paramName);
        if (stringValue != null) {
            try {
                value = Long.parseLong(stringValue);
            }
            catch (NumberFormatException e) {
                throw new CatalogBadRequestException(String.format("Cannot parse \"%s\" parameter: %s", paramName, stringValue));
            }
        }
        if (value < 1L) {
            throw new CatalogBadRequestException(String.format("Parameter \"%s\" must be positive: %s", paramName, value));
        }
        return value;
    }

    public static void validateNoExtraParameters(String operationName, Map<String, String> parameters, Set<String> expectedParameters) {
        TreeSet<String> unexpectedParameters = new TreeSet<String>();
        for (String parameter : parameters.keySet()) {
            if (expectedParameters.contains(parameter)) continue;
            unexpectedParameters.add(parameter);
        }
        if (!unexpectedParameters.isEmpty()) {
            throw new CatalogBadRequestException(String.format("Unexpected parameters for \"%s\" operation: %s", operationName, unexpectedParameters));
        }
    }
}

