/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.client;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;

public class ResultPage {
    public static final String QUERY_PARAM_PAGE_TOKEN = "pageToken";
    public static final String QUERY_PARAM_PAGE_SIZE = "pageSize";
    public static final ResultPage ALL = new ResultPage(Optional.empty(), OptionalInt.empty());
    private final Optional<String> pageToken;
    private final OptionalInt pageSize;

    public ResultPage(Optional<String> pageToken, OptionalInt pageSize) {
        this.pageToken = Objects.requireNonNull(pageToken, QUERY_PARAM_PAGE_TOKEN);
        this.pageSize = Objects.requireNonNull(pageSize, QUERY_PARAM_PAGE_SIZE);
    }

    public static ResultPage fromQueryParams(String pageToken, Integer pageSize) {
        OptionalInt limit;
        if (pageSize != null) {
            if (pageSize <= 0) {
                throw new CatalogBadRequestException(String.format("Page size (%d) must be positive", pageSize));
            }
            limit = OptionalInt.of(pageSize);
        } else {
            limit = OptionalInt.empty();
        }
        return new ResultPage(pageToken == null || pageToken.trim().isEmpty() ? Optional.empty() : Optional.of(pageToken.trim()), limit);
    }

    public static Map<String, String> toQueryParams(ResultPage page) {
        if (page == null || page.pageToken().isEmpty() && page.pageSize().isEmpty()) {
            page = ALL;
        }
        if (page == ALL) {
            return Map.of();
        }
        HashMap<String, String> res = HashMap.newHashMap(2);
        if (page.pageToken().isPresent()) {
            res.put(QUERY_PARAM_PAGE_TOKEN, page.pageToken().get());
        }
        if (page.pageSize().isPresent()) {
            res.put(QUERY_PARAM_PAGE_SIZE, Integer.toString(page.pageSize().getAsInt()));
        }
        return res;
    }

    public Optional<String> pageToken() {
        return this.pageToken;
    }

    public OptionalInt pageSize() {
        return this.pageSize;
    }

    public ResultPage withPageToken(String pageToken) {
        return new ResultPage(Optional.ofNullable(pageToken), this.pageSize);
    }
}

