/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.UUID;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.spi.model.ObjectGroupCreateRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupInfo;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemAddRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemInfo;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupObjectInfo;
import ru.cedrusdata.catalog.spi.model.ObjectGroupObjectListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupUpdateRequest;

public class CatalogObjectGroupClient {
    private final InternalCatalogClient delegate;

    public CatalogObjectGroupClient(InternalCatalogClient delegate) {
        this.delegate = delegate;
    }

    public void createObjectGroup(ObjectGroupCreateRequest request) {
        this.delegate.createObjectGroup(request);
    }

    public void updateObjectGroup(String objectGroupName, ObjectGroupUpdateRequest request) {
        this.delegate.updateObjectGroup(objectGroupName, request);
    }

    public void deleteObjectGroup(String objectGroupName) {
        this.delegate.deleteObjectGroup(objectGroupName);
    }

    public ObjectGroupInfo getObjectGroup(String objectGroupName) {
        return this.delegate.getObjectGroup(objectGroupName);
    }

    public ObjectGroupListResponse listObjectGroups(ResultPage page) {
        return this.delegate.listObjectGroups(page);
    }

    public List<ObjectGroupInfo> listAllObjectGroups() {
        ObjectGroupListResponse response;
        ArrayList<ObjectGroupInfo> res = new ArrayList<ObjectGroupInfo>();
        String nextPageToken = null;
        do {
            response = this.listObjectGroups(new ResultPage(Optional.ofNullable(nextPageToken), OptionalInt.empty()));
            res.addAll(response.getItems());
        } while ((nextPageToken = response.getNextPageToken()) != null);
        return res;
    }

    public ObjectGroupObjectListResponse listObjectGroupObjects(String objectGroupName, Optional<UUID> itemId, Optional<String> objectType, ResultPage page) {
        return this.delegate.listObjectGroupObjects(objectGroupName, itemId, objectType, page);
    }

    public List<ObjectGroupObjectInfo> listAllObjectGroupObjects(String objectGroupName, Optional<UUID> itemId, Optional<String> objectType) {
        ObjectGroupObjectListResponse response;
        ArrayList<ObjectGroupObjectInfo> res = new ArrayList<ObjectGroupObjectInfo>();
        String nextPageToken = null;
        do {
            response = this.listObjectGroupObjects(objectGroupName, itemId, objectType, new ResultPage(Optional.ofNullable(nextPageToken), OptionalInt.empty()));
            res.addAll(response.getItems());
        } while ((nextPageToken = response.getNextPageToken()) != null);
        return res;
    }

    public void addObjectGroupItem(String objectGroupName, ObjectGroupItemAddRequest request) {
        this.delegate.addObjectGroupItem(objectGroupName, request);
    }

    public void deleteObjectGroupItem(String objectGroupName, UUID itemId) {
        this.delegate.deleteObjectGroupItem(objectGroupName, itemId);
    }

    public ObjectGroupItemListResponse listObjectGroupItems(String objectGroupName, ResultPage page) {
        return this.delegate.listObjectGroupItems(objectGroupName, page);
    }

    public List<ObjectGroupItemInfo> listAllObjectGroupItems(String objectGroupName) {
        ObjectGroupItemListResponse response;
        ArrayList<ObjectGroupItemInfo> res = new ArrayList<ObjectGroupItemInfo>();
        String nextPageToken = null;
        do {
            response = this.listObjectGroupItems(objectGroupName, new ResultPage(Optional.ofNullable(nextPageToken), OptionalInt.empty()));
            res.addAll(response.getItems());
        } while ((nextPageToken = response.getNextPageToken()) != null);
        return res;
    }
}

