/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.spi.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.client.internal.InternalCatalogClient;
import ru.cedrusdata.catalog.spi.model.ComputeEngineCheckResponse;
import ru.cedrusdata.catalog.spi.model.ComputeEngineCreateRequest;
import ru.cedrusdata.catalog.spi.model.ComputeEngineInfo;
import ru.cedrusdata.catalog.spi.model.ComputeEngineListResponse;
import ru.cedrusdata.catalog.spi.model.ComputeEngineUpdateRequest;

public class CatalogComputeEngineClient {
    private final InternalCatalogClient delegate;

    public CatalogComputeEngineClient(InternalCatalogClient delegate) {
        this.delegate = delegate;
    }

    public void createEngine(ComputeEngineCreateRequest request) {
        this.delegate.createComputeEngine(request);
    }

    public void updateEngine(String engineName, ComputeEngineUpdateRequest request) {
        this.delegate.updateComputeEngine(engineName, request);
    }

    public void deleteEngine(String engineName) {
        this.delegate.deleteComputeEngine(engineName);
    }

    public ComputeEngineCheckResponse checkEngine(String engineName) {
        return this.delegate.checkComputeEngine(engineName);
    }

    public ComputeEngineInfo getEngine(String engineName) {
        return this.delegate.getComputeEngine(engineName);
    }

    public ComputeEngineListResponse listEngines(ResultPage page) {
        return this.delegate.listComputeEngines(page);
    }

    public List<ComputeEngineInfo> listAllEngines() {
        ComputeEngineListResponse response;
        ArrayList<ComputeEngineInfo> res = new ArrayList<ComputeEngineInfo>();
        String nextPageToken = null;
        do {
            response = this.listEngines(new ResultPage(Optional.ofNullable(nextPageToken), OptionalInt.empty()));
            res.addAll(response.getItems());
        } while ((nextPageToken = response.getNextPageToken()) != null);
        return res;
    }
}

