/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.inject.Inject;
import io.airlift.http.client.HttpRequestFilter;
import io.airlift.http.client.Request;
import io.airlift.tracetoken.TraceTokenManager;
import java.util.Objects;

public class TraceTokenRequestFilter
implements HttpRequestFilter {
    public static final String TRACETOKEN_HEADER = "X-Airlift-Tracetoken";
    private final TraceTokenManager traceTokenManager;

    @Inject
    public TraceTokenRequestFilter(TraceTokenManager traceTokenManager) {
        this.traceTokenManager = Objects.requireNonNull(traceTokenManager, "traceTokenManager is null");
    }

    @Override
    public Request filterRequest(Request request) {
        Objects.requireNonNull(request, "request is null");
        String token = this.traceTokenManager.getCurrentRequestToken();
        if (token == null) {
            return request;
        }
        return Request.Builder.fromRequest(request).addHeader(TRACETOKEN_HEADER, token).build();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TraceTokenRequestFilter o = (TraceTokenRequestFilter)obj;
        return this.traceTokenManager.equals(o.traceTokenManager);
    }

    public int hashCode() {
        return this.traceTokenManager.hashCode();
    }
}

