/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.tracing;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import io.opentelemetry.semconv.ExceptionAttributes;
import java.util.Optional;

public final class Tracing {
    private Tracing() {
    }

    public static <T> Attributes attribute(AttributeKey<T> key, Optional<T> optionalValue) {
        return optionalValue.map(value -> Attributes.of((AttributeKey)key, (Object)value)).orElseGet(Attributes::empty);
    }

    public static <E extends Exception> void withTracing(Span span, CheckedRunnable<E> runnable) throws E {
        Tracing.withTracing(span, () -> {
            runnable.run();
            return null;
        });
    }

    public static <T, E extends Exception> T withTracing(Span span, CheckedSupplier<T, E> supplier) throws E {
        try {
            T t;
            block11: {
                Scope ignored = span.makeCurrent();
                try {
                    t = supplier.get();
                    if (ignored == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t2) {
                        span.setStatus(StatusCode.ERROR, t2.getMessage());
                        span.recordException(t2, Attributes.of((AttributeKey)ExceptionAttributes.EXCEPTION_ESCAPED, (Object)true));
                        throw t2;
                    }
                }
                ignored.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public static interface CheckedRunnable<E extends Exception> {
        public void run() throws E;
    }

    public static interface CheckedSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

