/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi;

import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.PageBuilderStatus;
import io.trino.spi.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class PageBuilder {
    private static final int DEFAULT_INITIAL_EXPECTED_ENTRIES = 8;
    private final BlockBuilder[] blockBuilders;
    private final List<Type> types;
    private PageBuilderStatus pageBuilderStatus;
    private int declaredPositions;

    public PageBuilder(List<? extends Type> types) {
        this(8, types);
    }

    public PageBuilder(int initialExpectedEntries, List<? extends Type> types) {
        this(initialExpectedEntries, 0x100000, types, Optional.empty());
    }

    public static PageBuilder withMaxPageSize(int maxPageBytes, List<? extends Type> types) {
        return new PageBuilder(8, maxPageBytes, types, Optional.empty());
    }

    private PageBuilder(int initialExpectedEntries, int maxPageBytes, List<? extends Type> types, Optional<BlockBuilder[]> templateBlockBuilders) {
        this.types = List.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.pageBuilderStatus = new PageBuilderStatus(maxPageBytes);
        this.blockBuilders = new BlockBuilder[types.size()];
        if (templateBlockBuilders.isPresent()) {
            BlockBuilder[] templates = templateBlockBuilders.get();
            PageBuilder.checkArgument(templates.length == types.size(), "Size of templates and types should match");
            for (int i = 0; i < this.blockBuilders.length; ++i) {
                this.blockBuilders[i] = templates[i].newBlockBuilderLike(this.pageBuilderStatus.createBlockBuilderStatus());
            }
        } else {
            for (int i = 0; i < this.blockBuilders.length; ++i) {
                this.blockBuilders[i] = types.get(i).createBlockBuilder(this.pageBuilderStatus.createBlockBuilderStatus(), initialExpectedEntries);
            }
        }
    }

    public void reset() {
        if (this.isEmpty()) {
            return;
        }
        this.pageBuilderStatus = new PageBuilderStatus(this.pageBuilderStatus.getMaxPageSizeInBytes());
        this.declaredPositions = 0;
        for (int i = 0; i < this.blockBuilders.length; ++i) {
            this.blockBuilders[i] = this.blockBuilders[i].newBlockBuilderLike(this.pageBuilderStatus.createBlockBuilderStatus());
        }
    }

    public void reset(int expectedEntries) {
        if (this.isEmpty()) {
            return;
        }
        this.pageBuilderStatus = new PageBuilderStatus(this.pageBuilderStatus.getMaxPageSizeInBytes());
        for (int i = 0; i < this.blockBuilders.length; ++i) {
            this.blockBuilders[i] = this.blockBuilders[i].newBlockBuilderLike(expectedEntries, this.pageBuilderStatus.createBlockBuilderStatus());
        }
        this.declaredPositions = 0;
    }

    public PageBuilder newPageBuilderLike() {
        return new PageBuilder(this.declaredPositions, this.pageBuilderStatus.getMaxPageSizeInBytes(), this.types, Optional.of(this.blockBuilders));
    }

    public BlockBuilder getBlockBuilder(int channel) {
        return this.blockBuilders[channel];
    }

    public Type getType(int channel) {
        return this.types.get(channel);
    }

    public void declarePosition() {
        ++this.declaredPositions;
    }

    public void declarePositions(int positions) {
        this.declaredPositions += positions;
    }

    public boolean isFull() {
        return this.declaredPositions == Integer.MAX_VALUE || this.pageBuilderStatus.isFull();
    }

    public boolean isEmpty() {
        return this.declaredPositions == 0;
    }

    public int getPositionCount() {
        return this.declaredPositions;
    }

    public long getSizeInBytes() {
        return this.pageBuilderStatus.getSizeInBytes();
    }

    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = 0L;
        for (BlockBuilder blockBuilder : this.blockBuilders) {
            retainedSizeInBytes += blockBuilder.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    public Page build() {
        if (this.blockBuilders.length == 0) {
            return new Page(this.declaredPositions);
        }
        Block[] blocks = new Block[this.blockBuilders.length];
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i] = this.blockBuilders[i].build();
            if (blocks[i].getPositionCount() == this.declaredPositions) continue;
            throw new IllegalStateException(String.format("Declared positions (%s) does not match block %s's number of entries (%s)", this.declaredPositions, i, blocks[i].getPositionCount()));
        }
        return Page.wrapBlocksWithoutCopy(this.declaredPositions, blocks);
    }

    private static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

