/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.local;

import com.google.inject.Inject;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.local.LocalFileSystemFactory;
import java.net.URI;
import java.util.Optional;
import ru.cedrusdata.catalog.filesystem.common.CatalogTrinoFileSystemFactory;

public class CatalogLocalTrinoFileSystemFactory
extends CatalogTrinoFileSystemFactory {
    private static final String LOCAL_SCHEME = "local";

    @Inject
    public CatalogLocalTrinoFileSystemFactory(LocalFileSystemFactory delegate) {
        super((TrinoFileSystemFactory)delegate);
    }

    protected Optional<String> isLocationValid(URI locationUri) {
        if (LOCAL_SCHEME.equalsIgnoreCase(locationUri.getScheme())) {
            return Optional.empty();
        }
        return Optional.of(String.format("File system location \"%s\" has invalid scheme (must be \"%s\")", locationUri, LOCAL_SCHEME));
    }

    public void close() {
    }
}

