/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.filesystem.common;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.weakref.jmx.ObjectNameBuilder;
import org.weakref.jmx.ObjectNameGenerator;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemType;

public class CatalogTrinoFileSystemJmxObjectNameGenerator
implements ObjectNameGenerator {
    private static final List<String> RESTRICTED_DOMAINS = List.of("io.trino");
    private static final String RESTRICTED_DOMAIN_PREFIX = "cedrusdata.catalog.plugin.filesystem";
    private final CatalogFileSystemType fileSystemType;
    private final String fileSystemName;
    private final Map<String, String> domainRemapping;
    private final Map<String, String> classNameRemapping;
    private final boolean strictNameCheck;

    public CatalogTrinoFileSystemJmxObjectNameGenerator(CatalogFileSystemType fileSystemType, String fileSystemName, Map<String, String> domainRemapping, Map<String, String> classNameRemapping, boolean strictNameCheck) {
        this.fileSystemType = fileSystemType;
        this.fileSystemName = fileSystemName;
        this.domainRemapping = domainRemapping;
        this.classNameRemapping = classNameRemapping;
        this.strictNameCheck = strictNameCheck;
    }

    public String generatedNameOf(Class<?> type) {
        return this.generatedNameOf(type, Map.of());
    }

    public String generatedNameOf(Class<?> type, Map<String, String> properties) {
        String domain = this.toDomain(type);
        Map<String, String> finalProperties = this.generateProperties(type, properties);
        return new ObjectNameBuilder(domain).withProperties(finalProperties).build();
    }

    private Map<String, String> generateProperties(Class<?> type, Map<String, String> properties) {
        HashMap<String, String> res = new HashMap<String, String>(properties);
        res.put("name", this.fileSystemName);
        String typeName = res.getOrDefault("type", type.getSimpleName());
        res.put("type", this.classNameRemapping.getOrDefault(typeName, typeName));
        return res;
    }

    private String toDomain(Class<?> type) {
        Object domain = type.getPackage().getName();
        for (Map.Entry<String, String> entry : this.domainRemapping.entrySet()) {
            String packagePrefix = entry.getKey();
            String replacement = entry.getValue();
            if (!((String)domain).startsWith(packagePrefix)) continue;
            domain = replacement + ((String)domain).substring(packagePrefix.length());
            break;
        }
        for (String restrictedDomain : RESTRICTED_DOMAINS) {
            if (!((String)domain).startsWith(restrictedDomain)) continue;
            if (this.strictNameCheck) {
                throw new IllegalStateException(String.format("Catalog JMX bean %s.%s is in restricted domain %s", domain, type.getName(), restrictedDomain));
            }
            domain = "cedrusdata.catalog.plugin.filesystem." + this.fileSystemType.name().toLowerCase(Locale.ROOT) + "." + (String)domain;
            break;
        }
        return domain;
    }
}

