/*
 * Decompiled with CFR 0.152.
 */
package org.ishugaliy.allgood.consistent.hash;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Random;
import org.ishugaliy.allgood.consistent.hash.HashRing;
import org.ishugaliy.allgood.consistent.hash.hasher.DefaultHasher;
import org.ishugaliy.allgood.consistent.hash.hasher.Hasher;
import org.ishugaliy.allgood.consistent.hash.node.Node;

public final class HashRingBuilder<T extends Node> {
    private String name;
    private Hasher hash;
    private int partitionRate = 1000;
    private Collection<T> nodes = Collections.emptyList();

    public HashRingBuilder<T> name(String name) {
        Objects.requireNonNull(name, "Name can not be null");
        this.name = name;
        return this;
    }

    public HashRingBuilder<T> hasher(Hasher hash) {
        this.hash = hash;
        return this;
    }

    public HashRingBuilder<T> partitionRate(int partitionRate) {
        if (partitionRate < 1) {
            throw new IllegalArgumentException("Replication Rate can not be less than 1");
        }
        this.partitionRate = partitionRate;
        return this;
    }

    public HashRingBuilder<T> nodes(Collection<T> nodes) {
        Objects.requireNonNull(nodes, "Nodes list can not be null");
        this.nodes = nodes;
        return this;
    }

    public HashRing<T> build() {
        this.name = this.name != null ? this.name : this.generateName();
        this.hash = this.hash != null ? this.hash : DefaultHasher.MURMUR_3;
        HashRing<T> ring = new HashRing<T>(this.name, this.hash, this.partitionRate);
        ring.addAll(this.nodes);
        return ring;
    }

    private String generateName() {
        return "hash_ring_" + new Random().nextInt(10000);
    }
}

