/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.tracing;

import com.google.inject.Inject;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import java.util.Optional;
import java.util.function.Predicate;
import ru.cedrusdata.catalog.config.CatalogConfig;
import ru.cedrusdata.catalog.tracing.TracingModes;

public class TracingProvider {
    private final OpenTelemetry openTelemetry;
    private final Tracer tracer;
    private final TracingModes modes;

    @Inject
    public TracingProvider(OpenTelemetry openTelemetry, Tracer tracer, CatalogConfig config) {
        this.openTelemetry = openTelemetry;
        this.tracer = tracer;
        this.modes = config.getTelemetryEnabled();
    }

    public Optional<OpenTelemetry> telemetryForHttp() {
        return this.telemetryFor(TracingModes::traceHttp);
    }

    public Optional<OpenTelemetry> telemetryForApi() {
        return this.telemetryFor(TracingModes::traceApi);
    }

    public Optional<OpenTelemetry> telemetryForFileSystem() {
        return this.telemetryFor(TracingModes::traceFileSystem);
    }

    public Optional<OpenTelemetry> telemetryForStore() {
        return this.telemetryFor(TracingModes::traceStore);
    }

    private Optional<OpenTelemetry> telemetryFor(Predicate<TracingModes> predicate) {
        return predicate.test(this.modes) ? Optional.of(this.openTelemetry) : Optional.empty();
    }

    public Optional<Tracer> tracerForHttp() {
        return this.tracerFor(TracingModes::traceHttp);
    }

    public Optional<Tracer> tracerForApi() {
        return this.tracerFor(TracingModes::traceApi);
    }

    public Optional<Tracer> tracerForFileSystem() {
        return this.tracerFor(TracingModes::traceFileSystem);
    }

    public Optional<Tracer> tracerForStore() {
        return this.tracerFor(TracingModes::traceStore);
    }

    private Optional<Tracer> tracerFor(Predicate<TracingModes> predicate) {
        return predicate.test(this.modes) ? Optional.of(this.tracer) : Optional.empty();
    }
}

