/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc.postgres;

import com.google.common.base.Verify;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import io.airlift.configuration.ConfigBinder;
import java.util.Optional;
import java.util.Properties;
import ru.cedrusdata.catalog.config.store.CatalogJdbcPostgresqlStoreConfig;
import ru.cedrusdata.catalog.store.jdbc.JdbcConnectionDetails;
import ru.cedrusdata.catalog.store.jdbc.JdbcDatabaseType;
import ru.cedrusdata.catalog.store.jdbc.SqlDialect;
import ru.cedrusdata.catalog.store.jdbc.postgres.PostgresqlSqlDialect;

public class PostgresqlCatalogStoreModule
implements Module {
    public void configure(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(CatalogJdbcPostgresqlStoreConfig.class);
        binder.bind(SqlDialect.class).to(PostgresqlSqlDialect.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    public static JdbcConnectionDetails getConnectionDetails(CatalogJdbcPostgresqlStoreConfig config) {
        Optional<JdbcDatabaseType> type = JdbcDatabaseType.resolveFromJdbcUrl(config.getStorePostgresqlJdbcUrl());
        Verify.verify((boolean)type.isPresent(), (String)("Failed to determine database type for URL " + config.getStorePostgresqlJdbcUrl()), (Object[])new Object[0]);
        Properties properties = new Properties();
        properties.put("user", config.getStorePostgresqlUsername());
        if (config.getStorePostgresqlPassword().isPresent()) {
            properties.put("password", config.getStorePostgresqlPassword().get());
        }
        return new JdbcConnectionDetails(type.get(), config.getStorePostgresqlJdbcUrl(), Optional.of(config.getStorePostgresqlUsername()), config.getStorePostgresqlPassword(), properties, true);
    }
}

