/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jdbi.v3.core.statement.Query;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;

public interface QueryCondition {
    public static final FieldHandler OBJECT_GROUP_NAME = (fieldName, value, conditions) -> {
        if (value instanceof String) {
            conditions.add(QueryCondition.eq(fieldName, CatalogObjectNameValidation.VALIDATION_OBJECT_GROUP.normalizeObjectName((String)value), fieldName + "_eq"));
            return;
        }
        throw new CatalogBadRequestException(String.format("Invalid filter expression for field \"%s\"", fieldName));
    };
    public static final FieldHandler MAINTENANCE_JOB_NAME = (fieldName, value, conditions) -> {
        if (value instanceof String) {
            conditions.add(QueryCondition.eq(fieldName, CatalogObjectNameValidation.VALIDATION_MAINTENANCE_JOB.normalizeObjectName((String)value), fieldName + "_eq"));
            return;
        }
        throw new CatalogBadRequestException(String.format("Invalid filter expression for field \"%s\"", fieldName));
    };

    public String sql();

    public void bind(Query var1);

    public static QueryCondition sql(final String sql) {
        return new QueryCondition(){

            @Override
            public String sql() {
                return sql;
            }

            @Override
            public void bind(Query query) {
            }
        };
    }

    public static QueryCondition eq(final String column, final Object value) {
        return new QueryCondition(){

            @Override
            public String sql() {
                return String.format("%s = :%s", column, column);
            }

            @Override
            public void bind(Query query) {
                query.bind(column, value);
            }
        };
    }

    public static QueryCondition eq(final String column, final Object value, final String parameterName) {
        return new QueryCondition(){

            @Override
            public String sql() {
                return String.format("%s = :%s", column, parameterName);
            }

            @Override
            public void bind(Query query) {
                query.bind(parameterName, value);
            }
        };
    }

    public static QueryCondition in(final String column, final Iterable<?> values, final String parameterName) {
        return new QueryCondition(){

            @Override
            public String sql() {
                return String.format("%s IN (<%s>)", column, parameterName);
            }

            @Override
            public void bind(Query query) {
                query.bindList(parameterName, values);
            }
        };
    }

    public static List<QueryCondition> parseFilter(Map<String, Object> filter, Map<String, Field> supportedFieldHandlers) {
        ArrayList<QueryCondition> conditions = new ArrayList<QueryCondition>(supportedFieldHandlers.size());
        for (Map.Entry<String, Object> e : filter.entrySet()) {
            String fieldName = e.getKey();
            Field field = supportedFieldHandlers.get(fieldName);
            if (field == null) {
                throw new CatalogBadRequestException(String.format("Filter by field \"%s\" is not supported", fieldName));
            }
            field.fieldHandler.createConditions(field.sqlFieldName.orElse(fieldName), e.getValue(), conditions);
        }
        return conditions;
    }

    public record Field(FieldHandler fieldHandler, Optional<String> sqlFieldName) {
        public Field(FieldHandler fieldHandler) {
            this(fieldHandler, Optional.empty());
        }
    }

    public static interface FieldHandler {
        public void createConditions(String var1, Object var2, List<QueryCondition> var3);
    }
}

