/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Query;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessor;

public class PageProcessorFactory<T> {
    private final ListQueryBuilder<T> listQueryBuilder;
    private final int maxPageSize;

    public PageProcessorFactory(ListQueryBuilder<T> listQueryBuilder, int maxPageSize) {
        this.listQueryBuilder = listQueryBuilder;
        this.maxPageSize = maxPageSize;
    }

    public PageProcessor<T> create(ResultPage page) {
        int limit = this.limit(page);
        return new PageProcessor<T>(this.listQueryBuilder, page.pageToken(), limit);
    }

    public <R> R list(JdbcAccessor accessor, ResultPage page, ResultSetConverter<T> itemConverter, Predicate<T> itemPredicate, BiFunction<List<T>, String, R> resultConverter) {
        return this.list(accessor, page, PageProcessor::createQuery, itemConverter, itemPredicate, resultConverter);
    }

    public <R> R list(JdbcAccessor accessor, ResultPage page, BiFunction<PageProcessor<T>, Handle, Query> queryFactory, ResultSetConverter<T> itemConverter, Predicate<T> itemPredicate, BiFunction<List<T>, String, R> resultConverter) {
        String nextPageToken;
        ArrayList res = new ArrayList(4);
        int limit = this.limit(page);
        do {
            PageProcessor pageProcessor = this.create(page);
            accessor.execute(handle -> {
                Query query = (Query)queryFactory.apply(pageProcessor, (Handle)handle);
                query.map((rs, ctx) -> itemConverter.convert(rs)).stream().filter(itemPredicate).limit(limit - res.size()).forEach(res::add);
            });
            nextPageToken = pageProcessor.nextPageToken(res);
            page = page.withPageToken(nextPageToken);
        } while (res.size() < limit && nextPageToken != null);
        return resultConverter.apply(res, nextPageToken);
    }

    private int limit(ResultPage page) {
        return Math.min(this.maxPageSize, page.pageSize().isPresent() ? page.pageSize().getAsInt() : Integer.MAX_VALUE);
    }

    @FunctionalInterface
    public static interface ResultSetConverter<T> {
        public T convert(ResultSet var1) throws SQLException;
    }
}

