/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.core.PageData;
import ru.cedrusdata.catalog.core.security.provider.SecurityProviderDetails;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogSecurityProviderAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.CatalogSecurityProviderInUseException;
import ru.cedrusdata.catalog.store.SecurityProviderStore;
import ru.cedrusdata.catalog.store.StoreTracingInterceptor;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;
import ru.cedrusdata.catalog.store.jdbc.JdbcUtils;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorFactory;
import ru.cedrusdata.catalog.store.jdbc.PageSort;

@StoreTracingInterceptor.Traceable
public class JdbcSecurityProviderStore
implements SecurityProviderStore {
    @Language(value="SQL")
    private static final String SQL_DELETE_BY_ID = "DELETE FROM metastore_security_provider\nWHERE provider_id = :provider_id\n";
    @Language(value="SQL")
    private static final String SQL_LIST = "SELECT\n    sp.provider_id,\n    sp.provider_name,\n    sp.provider_type,\n    sp.description,\n    sp.properties,\n    sp.owner_id,\n    p.principal_name owner_name\nFROM metastore_security_provider sp\n    LEFT OUTER JOIN metastore_principal p ON sp.owner_id = p.principal_id\n";
    @Language(value="SQL")
    private static final String SQL_GET_BY_NAME = "SELECT\n    sp.provider_id,\n    sp.provider_name,\n    sp.provider_type,\n    sp.description,\n    sp.properties,\n    sp.owner_id,\n    p.principal_name owner_name\nFROM metastore_security_provider sp\n    LEFT OUTER JOIN metastore_principal p ON sp.owner_id = p.principal_id\nWHERE provider_name = :provider_name\n";
    @Language(value="SQL")
    private static final String SQL_CREATE = "INSERT INTO metastore_security_provider (\n    provider_id,\n    provider_name,\n    provider_type,\n    description,\n    properties,\n    owner_id)\nVALUES (\n    :provider_id,\n    :provider_name,\n    :provider_type,\n    :description,\n    :properties,\n    :owner_id)\nON CONFLICT DO NOTHING";
    @Language(value="SQL")
    private static final String SQL_UPDATE_BY_ID = "UPDATE metastore_security_provider\nSET\n    provider_name = :provider_name,\n    description = :description,\n    properties = :properties\nWHERE provider_id = :provider_id\n";
    @Language(value="SQL")
    private static final String SQL_UPDATE_OWNER = "UPDATE metastore_security_provider\nSET owner_id = :owner_id\nWHERE provider_id = :provider_id\n";
    private final JdbcAccessor accessor;
    private final PageProcessorFactory<SecurityProviderDetails> listPageProcessorFactory;

    @Inject
    public JdbcSecurityProviderStore(JdbcAccessor accessor, CatalogStoreConfig config) {
        this.accessor = accessor;
        this.listPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_LIST, PageSort.sort(PageSort.uuidSort("provider_id", SecurityProviderDetails::id))), config.getStoreMaxPageSize());
    }

    @Override
    public boolean createIfNotExists(UUID id, String name, String description, String type, Map<String, String> properties, UUID ownerId) {
        return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_CREATE).bind("provider_id", id)).bind("provider_name", name)).bind("provider_type", type)).bind("description", description)).bind("properties", JdbcUtils.propertiesToString(properties))).bind("owner_id", ownerId)).execute() == 1);
    }

    @Override
    public Optional<SecurityProviderDetails> details(String name) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_GET_BY_NAME).bind("provider_name", name)).map((rs, ctx) -> this.toDetails(rs)).findOne());
    }

    @Override
    public PageData<SecurityProviderDetails> list(ResultPage page, Predicate<SecurityProviderDetails> predicate) {
        return this.listPageProcessorFactory.list(this.accessor, page, this::toDetails, predicate, PageData::new);
    }

    @Override
    public boolean deleteIfExists(UUID id, String name) {
        try {
            return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_DELETE_BY_ID).bind("provider_id", id)).execute() == 1);
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new CatalogSecurityProviderInUseException(name);
            }
            throw e;
        }
    }

    @Override
    public boolean updateIfExists(UUID id, String name, String description, Map<String, String> properties) {
        try {
            return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)handle.createUpdate(SQL_UPDATE_BY_ID).bind("provider_id", id)).bind("provider_name", name)).bind("description", description)).bind("properties", JdbcUtils.propertiesToString(properties))).execute() == 1);
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new CatalogSecurityProviderAlreadyExistsException(name);
            }
            throw e;
        }
    }

    @Override
    public boolean updateOwner(UUID id, UUID ownerId) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_UPDATE_OWNER).bind("provider_id", id)).bind("owner_id", ownerId)).execute() == 1);
    }

    private SecurityProviderDetails toDetails(ResultSet rs) throws SQLException {
        return new SecurityProviderDetails(this.accessor.getUuid(rs, "provider_id"), rs.getString("provider_name"), rs.getString("description"), rs.getString("provider_type"), JdbcUtils.stringToProperties(rs.getString("properties")), this.accessor.getOptionalUuid(rs, "owner_id"), rs.getString("owner_name"));
    }
}

