/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.core.PageData;
import ru.cedrusdata.catalog.core.maintenance.MaintenanceJobInfoEx;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogMaintenanceJobAlreadyExistsException;
import ru.cedrusdata.catalog.spi.model.JobScheduleConfig;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobInfo;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationConfig;
import ru.cedrusdata.catalog.store.MaintenanceJobStore;
import ru.cedrusdata.catalog.store.NestedStoreException;
import ru.cedrusdata.catalog.store.StoreTracingInterceptor;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;
import ru.cedrusdata.catalog.store.jdbc.JdbcUtils;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorFactory;
import ru.cedrusdata.catalog.store.jdbc.PageSort;
import ru.cedrusdata.catalog.store.jdbc.QueryCondition;

@StoreTracingInterceptor.Traceable
public class JdbcMaintenanceJobStore
implements MaintenanceJobStore {
    @Language(value="SQL")
    private static final String SQL_CREATE = "INSERT INTO metastore_maintenance_job (\n    job_id,\n    job_name,\n    schedule_expression,\n    schedule_timezone_id,\n    description,\n    owner_id,\n    run_as_principal_id,\n    operation_name,\n    operation_parameters,\n    operation_engine_id,\n    target_object_group_id,\n    engine_config)\nVALUES (\n    :job_id,\n    :job_name,\n    :schedule_expression,\n    :schedule_timezone_id,\n    :description,\n    :owner_id,\n    :run_as_principal_id,\n    :operation_name,\n    :operation_parameters,\n    :operation_engine_id,\n    :target_object_group_id,\n    :engine_config)\nON CONFLICT DO NOTHING\n";
    @Language(value="SQL")
    private static final String SQL_SELECT_DETAILS = "SELECT\n    job_id,\n    job_name,\n    schedule_expression,\n    schedule_timezone_id,\n    job.description description,\n    operation_name,\n    operation_parameters,\n    engine_config,\n    job.operation_engine_id operation_engine_id,\n    ce.engine_name engine_name,\n    ce.owner_id engine_owner_id,\n    job.target_object_group_id target_object_group_id,\n    og.group_name target_object_group_name,\n    job.owner_id owner_id,\n    po.principal_name owner_name,\n    pr.principal_name run_as_name,\n    run_as_principal_id,\n    (SELECT MAX(started_at) FROM metastore_maintenance_operation op WHERE op.job_id = job.job_id) last_execution_at\nFROM metastore_maintenance_job job\n    JOIN metastore_compute_engine ce ON job.operation_engine_id = ce.engine_id\n    JOIN metastore_object_group og ON job.target_object_group_id = og.group_id\n    JOIN metastore_principal po ON job.owner_id = po.principal_id\n    JOIN metastore_principal pr ON job.run_as_principal_id = pr.principal_id\n";
    @Language(value="SQL")
    private static final String SQL_GET_BY_NAME = "SELECT\n    job_id,\n    job_name,\n    schedule_expression,\n    schedule_timezone_id,\n    job.description description,\n    operation_name,\n    operation_parameters,\n    engine_config,\n    job.operation_engine_id operation_engine_id,\n    ce.engine_name engine_name,\n    ce.owner_id engine_owner_id,\n    job.target_object_group_id target_object_group_id,\n    og.group_name target_object_group_name,\n    job.owner_id owner_id,\n    po.principal_name owner_name,\n    pr.principal_name run_as_name,\n    run_as_principal_id,\n    (SELECT MAX(started_at) FROM metastore_maintenance_operation op WHERE op.job_id = job.job_id) last_execution_at\nFROM metastore_maintenance_job job\n    JOIN metastore_compute_engine ce ON job.operation_engine_id = ce.engine_id\n    JOIN metastore_object_group og ON job.target_object_group_id = og.group_id\n    JOIN metastore_principal po ON job.owner_id = po.principal_id\n    JOIN metastore_principal pr ON job.run_as_principal_id = pr.principal_id\n WHERE job_name = :job_name";
    @Language(value="SQL")
    private static final String SQL_GET_BY_ID = "SELECT\n    job_id,\n    job_name,\n    schedule_expression,\n    schedule_timezone_id,\n    job.description description,\n    operation_name,\n    operation_parameters,\n    engine_config,\n    job.operation_engine_id operation_engine_id,\n    ce.engine_name engine_name,\n    ce.owner_id engine_owner_id,\n    job.target_object_group_id target_object_group_id,\n    og.group_name target_object_group_name,\n    job.owner_id owner_id,\n    po.principal_name owner_name,\n    pr.principal_name run_as_name,\n    run_as_principal_id,\n    (SELECT MAX(started_at) FROM metastore_maintenance_operation op WHERE op.job_id = job.job_id) last_execution_at\nFROM metastore_maintenance_job job\n    JOIN metastore_compute_engine ce ON job.operation_engine_id = ce.engine_id\n    JOIN metastore_object_group og ON job.target_object_group_id = og.group_id\n    JOIN metastore_principal po ON job.owner_id = po.principal_id\n    JOIN metastore_principal pr ON job.run_as_principal_id = pr.principal_id\n WHERE job_id = :job_id";
    @Language(value="SQL")
    private static final String SQL_GET_ID_BY_NAME = "SELECT job_id FROM metastore_maintenance_job WHERE job_name = :job_name";
    @Language(value="SQL")
    private static final String SQL_UPDATE = "UPDATE metastore_maintenance_job\nSET\n    job_name = :job_name,\n    schedule_expression = :schedule_expression,\n    schedule_timezone_id = :schedule_timezone_id,\n    target_object_group_id = :target_object_group_id,\n    run_as_principal_id = :run_as_principal_id,\n    description = :description\nWHERE job_id = :job_id\n";
    @Language(value="SQL")
    private static final String SQL_UPDATE_OWNER = "UPDATE metastore_maintenance_job\nSET\n    owner_id = :owner_id\nWHERE job_id = :job_id\n";
    @Language(value="SQL")
    private static final String SQL_DELETE_BY_ID = "DELETE FROM metastore_maintenance_job\nWHERE job_id = :job_id\n";
    @Language(value="SQL")
    private static final String SQL_LIST = "SELECT\n    job_id,\n    job_name,\n    schedule_expression,\n    schedule_timezone_id,\n    job.description description,\n    operation_name,\n    operation_parameters,\n    engine_config,\n    job.operation_engine_id operation_engine_id,\n    ce.engine_name engine_name,\n    ce.owner_id engine_owner_id,\n    job.target_object_group_id target_object_group_id,\n    og.group_name target_object_group_name,\n    job.owner_id owner_id,\n    po.principal_name owner_name,\n    pr.principal_name run_as_name,\n    run_as_principal_id,\n    (SELECT MAX(started_at) FROM metastore_maintenance_operation op WHERE op.job_id = job.job_id) last_execution_at\nFROM metastore_maintenance_job job\n    JOIN metastore_compute_engine ce ON job.operation_engine_id = ce.engine_id\n    JOIN metastore_object_group og ON job.target_object_group_id = og.group_id\n    JOIN metastore_principal po ON job.owner_id = po.principal_id\n    JOIN metastore_principal pr ON job.run_as_principal_id = pr.principal_id\n";
    private final JdbcAccessor accessor;
    private final PageProcessorFactory<MaintenanceJobInfoEx> listPageProcessorFactory;

    @Inject
    public JdbcMaintenanceJobStore(JdbcAccessor accessor, CatalogStoreConfig config) {
        this.accessor = accessor;
        this.listPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder("SELECT\n    job_id,\n    job_name,\n    schedule_expression,\n    schedule_timezone_id,\n    job.description description,\n    operation_name,\n    operation_parameters,\n    engine_config,\n    job.operation_engine_id operation_engine_id,\n    ce.engine_name engine_name,\n    ce.owner_id engine_owner_id,\n    job.target_object_group_id target_object_group_id,\n    og.group_name target_object_group_name,\n    job.owner_id owner_id,\n    po.principal_name owner_name,\n    pr.principal_name run_as_name,\n    run_as_principal_id,\n    (SELECT MAX(started_at) FROM metastore_maintenance_operation op WHERE op.job_id = job.job_id) last_execution_at\nFROM metastore_maintenance_job job\n    JOIN metastore_compute_engine ce ON job.operation_engine_id = ce.engine_id\n    JOIN metastore_object_group og ON job.target_object_group_id = og.group_id\n    JOIN metastore_principal po ON job.owner_id = po.principal_id\n    JOIN metastore_principal pr ON job.run_as_principal_id = pr.principal_id\n", PageSort.sort(PageSort.uuidSort("job_id", MaintenanceJobInfoEx::id))), config.getStoreMaxPageSize());
    }

    @Override
    public Optional<UUID> createNewJobIfNotExists(String jobName, String scheduleExpression, String scheduleTimeZoneId, String description, UUID ownerId, UUID runAsId, String operationName, Map<String, String> operationParameters, String operationEngineName, UUID operationEngineId, Map<String, String> engineConfig, String targetObjectGroupName, UUID targetObjectGroupId) {
        UUID jobId = UUID.randomUUID();
        boolean created = this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_CREATE).bind("job_id", jobId)).bind("job_name", jobName)).bind("schedule_expression", scheduleExpression)).bind("schedule_timezone_id", scheduleTimeZoneId)).bind("description", description)).bind("owner_id", ownerId)).bind("run_as_principal_id", runAsId)).bind("operation_name", operationName)).bind("operation_parameters", JdbcUtils.propertiesToString(operationParameters))).bind("operation_engine_id", operationEngineId)).bind("target_object_group_id", targetObjectGroupId)).bind("engine_config", JdbcUtils.propertiesToString(engineConfig))).execute() == 1);
        return Optional.ofNullable(created ? jobId : null);
    }

    @Override
    public boolean updateIfExists(UUID jobId, String jobName, String scheduleExpression, String scheduleTimeZoneId, String description, UUID runAsId, UUID targetObjectGroupId) {
        return this.accessor.execute(handle -> {
            try {
                return ((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_UPDATE).bind("job_id", jobId)).bind("job_name", jobName)).bind("schedule_expression", scheduleExpression)).bind("schedule_timezone_id", scheduleTimeZoneId)).bind("target_object_group_id", targetObjectGroupId)).bind("run_as_principal_id", runAsId)).bind("description", description)).execute() == 1;
            }
            catch (Exception e) {
                if (this.accessor.isConstraintViolationException(e)) {
                    throw new NestedStoreException((RuntimeException)new CatalogMaintenanceJobAlreadyExistsException(jobName));
                }
                throw e;
            }
        });
    }

    @Override
    public Optional<UUID> getJobId(String jobName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_GET_ID_BY_NAME).bind("job_name", jobName)).map((rs, ctx) -> this.accessor.getUuid(rs, "job_id")).findOne());
    }

    @Override
    public Optional<MaintenanceJobInfoEx> info(String jobName, BiFunction<JobScheduleConfig, Long, Long> nextExecutionTime) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_GET_BY_NAME).bind("job_name", jobName)).map((rs, ctx) -> this.toInfo(rs, nextExecutionTime)).findOne());
    }

    @Override
    public Optional<MaintenanceJobInfoEx> info(UUID jobId, BiFunction<JobScheduleConfig, Long, Long> nextExecutionTime) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_GET_BY_ID).bind("job_id", jobId)).map((rs, ctx) -> this.toInfo(rs, nextExecutionTime)).findOne());
    }

    @Override
    public PageData<MaintenanceJobInfoEx> list(ResultPage page, Predicate<MaintenanceJobInfoEx> predicate, List<QueryCondition> conditions, BiFunction<JobScheduleConfig, Long, Long> nextExecutionTime) {
        return this.listPageProcessorFactory.list(this.accessor, page, (pageProcessor, handle) -> pageProcessor.createQuery((Handle)handle, conditions), rs -> this.toInfo(rs, nextExecutionTime), predicate, PageData::new);
    }

    @Override
    public boolean updateOwnerIfExists(UUID jobId, UUID ownerId) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_UPDATE_OWNER).bind("job_id", jobId)).bind("owner_id", ownerId)).execute() == 1);
    }

    @Override
    public boolean deleteJob(UUID jobId) {
        return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_DELETE_BY_ID).bind("job_id", jobId)).execute() == 1);
    }

    private MaintenanceJobInfoEx toInfo(ResultSet rs, BiFunction<JobScheduleConfig, Long, Long> nextExecutionTime) throws SQLException {
        JobScheduleConfig jobScheduleConfig = new JobScheduleConfig(rs.getString("schedule_expression"), rs.getString("schedule_timezone_id"));
        MaintenanceJobInfo info = new MaintenanceJobInfo(rs.getString("job_name"), new MaintenanceOperationConfig(rs.getString("engine_name"), JdbcUtils.stringToProperties(rs.getString("engine_config")), rs.getString("operation_name"), JdbcUtils.stringToProperties(rs.getString("operation_parameters"))), jobScheduleConfig, rs.getString("target_object_group_name"), rs.getString("owner_name"), rs.getString("run_as_name"), rs.getString("description"), this.accessor.getLongOrNull(rs, "last_execution_at"), nextExecutionTime.apply(jobScheduleConfig, this.accessor.getLongOrNull(rs, "last_execution_at")));
        return new MaintenanceJobInfoEx(info, this.accessor.getUuid(rs, "job_id"), this.accessor.getUuid(rs, "target_object_group_id"), this.accessor.getUuid(rs, "operation_engine_id"), this.accessor.getOptionalUuid(rs, "engine_owner_id"), this.accessor.getUuid(rs, "owner_id"), this.accessor.getUuid(rs, "run_as_principal_id"));
    }
}

