/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceDetails;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceInfoEx;
import ru.cedrusdata.catalog.iceberg.namespace.IcebergNamespaceRestListResult;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergCatalogDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergNamespaceNotEmptyException;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceInfo;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.store.IcebergNamespaceStore;
import ru.cedrusdata.catalog.store.StoreTracingInterceptor;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;
import ru.cedrusdata.catalog.store.jdbc.JdbcUtils;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorFactory;
import ru.cedrusdata.catalog.store.jdbc.PageSort;
import ru.cedrusdata.catalog.store.jdbc.QueryCondition;

@StoreTracingInterceptor.Traceable
public class JdbcIcebergNamespaceStore
implements IcebergNamespaceStore {
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_CREATE = "INSERT INTO metastore_iceberg_namespace (\n    namespace_id,\n    namespace_name,\n    catalog_id,\n    owner_id,\n    properties)\nVALUES (\n    :namespace_id,\n    :namespace_name,\n    :catalog_id,\n    :owner_id,\n    :properties)\nON CONFLICT DO NOTHING\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_UPDATE_PROPERTIES = "UPDATE metastore_iceberg_namespace\nSET properties = :properties\nWHERE namespace_id = :namespace_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_UPDATE_OWNER = "UPDATE metastore_iceberg_namespace\nSET owner_id = :owner_id\nWHERE namespace_id = :namespace_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_DELETE = "DELETE FROM metastore_iceberg_namespace\nWHERE namespace_id = :namespace_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_DETAILS_ALL = "SELECT\n    namespace_id,\n    namespace_name,\n    catalog_id,\n    owner_id,\n    properties\nFROM metastore_iceberg_namespace\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_LIST_REST = "SELECT\n    n.namespace_id,\n    n.namespace_name,\n    n.owner_id namespace_owner_id,\n    c.owner_id catalog_owner_id\nFROM metastore_iceberg_namespace n\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE_LIST = "SELECT\n    n.namespace_id,\n    n.namespace_name,\n    n.owner_id namespace_owner_id,\n    p.principal_name namespace_owner_name,\n    n.properties,\n    n.catalog_id,\n    c.catalog_name,\n    c.owner_id catalog_owner_id\nFROM metastore_iceberg_namespace n\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n    LEFT OUTER JOIN metastore_principal p ON n.owner_id = p.principal_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_NAMESPACE = "SELECT\n    n.namespace_id,\n    n.namespace_name,\n    n.owner_id namespace_owner_id,\n    p.principal_name namespace_owner_name,\n    n.properties,\n    c.catalog_name,\n    n.catalog_id,\n    c.owner_id catalog_owner_id\nFROM metastore_iceberg_namespace n\n    INNER JOIN metastore_catalog c ON n.catalog_id = c.catalog_id\n    LEFT OUTER JOIN metastore_principal p ON n.owner_id = p.principal_id\nWHERE n.namespace_name = :namespace_name\n";
    private final JdbcAccessor accessor;
    private final PageProcessorFactory<IcebergNamespaceRestListResult.Entry> icebergNamespaceRestListPageProcessorFactory;
    private final PageProcessorFactory<IcebergNamespaceInfoEx> icebergNamespaceListPageProcessorFactory;

    @Inject
    public JdbcIcebergNamespaceStore(JdbcAccessor accessor, CatalogStoreConfig config) {
        this.accessor = accessor;
        int maxPageSize = config.getStoreMaxPageSize();
        this.icebergNamespaceRestListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_ICEBERG_NAMESPACE_LIST_REST, PageSort.sort(PageSort.uuidSort("n.namespace_id", IcebergNamespaceRestListResult.Entry::id))), maxPageSize);
        this.icebergNamespaceListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_ICEBERG_NAMESPACE_LIST, PageSort.sort(PageSort.uuidSort("n.namespace_id", IcebergNamespaceInfoEx::namespaceId))), maxPageSize);
    }

    @Override
    public Optional<UUID> restCreateIfNotExists(String namespaceName, UUID catalogId, String catalogName, UUID ownerId, Map<String, String> properties) {
        try {
            UUID namespaceId = UUID.randomUUID();
            return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_NAMESPACE_CREATE).bind("namespace_id", namespaceId)).bind("namespace_name", namespaceName)).bind("catalog_id", catalogId)).bind("owner_id", ownerId)).bind("properties", JdbcUtils.propertiesToString(properties))).execute() == 1 ? Optional.of(namespaceId) : Optional.empty());
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new IcebergCatalogDoesNotExistException(catalogName);
            }
            throw e;
        }
    }

    @Override
    public boolean restUpdateProperties(UUID namespaceId, Map<String, String> properties) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_ICEBERG_NAMESPACE_UPDATE_PROPERTIES).bind("namespace_id", namespaceId)).bind("properties", JdbcUtils.propertiesToString(properties))).execute() == 1);
    }

    @Override
    public boolean restDeleteIfExists(UUID namespaceId, String namespaceName, String catalogName) {
        try {
            return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_ICEBERG_NAMESPACE_DELETE).bind("namespace_id", namespaceId)).execute() == 1);
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new IcebergNamespaceNotEmptyException(namespaceName);
            }
            throw e;
        }
    }

    @Override
    public IcebergNamespaceRestListResult restList(UUID catalogId, ResultPage page, Predicate<IcebergNamespaceRestListResult.Entry> predicate) {
        return this.icebergNamespaceRestListPageProcessorFactory.list(this.accessor, page, (pageProcessor, handle) -> pageProcessor.createQuery((Handle)handle, QueryCondition.eq("c.catalog_id", catalogId)), this::toRestListEntry, predicate, IcebergNamespaceRestListResult::new);
    }

    private IcebergNamespaceRestListResult.Entry toRestListEntry(ResultSet rs) throws SQLException {
        return new IcebergNamespaceRestListResult.Entry(this.accessor.getUuid(rs, "namespace_id"), rs.getString("namespace_name"), this.accessor.getOptionalUuid(rs, "catalog_owner_id"), this.accessor.getOptionalUuid(rs, "namespace_owner_id"));
    }

    @Override
    public List<IcebergNamespaceDetails> listDetails() {
        return this.accessor.execute(handle -> handle.createQuery(SQL_ICEBERG_NAMESPACE_DETAILS_ALL).map((rs, ctx) -> this.toDetails(rs)).list());
    }

    private IcebergNamespaceDetails toDetails(ResultSet rs) throws SQLException {
        return new IcebergNamespaceDetails(this.accessor.getUuid(rs, "namespace_id"), rs.getString("namespace_name"), this.accessor.getUuid(rs, "catalog_id"), this.accessor.getOptionalUuid(rs, "owner_id"), JdbcUtils.stringToProperties(rs.getString("properties")));
    }

    @Override
    public IcebergNamespaceListResponse list(Optional<String> catalogName, ResultPage page, Predicate<IcebergNamespaceInfoEx> predicate) {
        List conditions = catalogName.isPresent() ? List.of(QueryCondition.eq("c.catalog_name", catalogName.get(), "catalog_name")) : List.of();
        return this.icebergNamespaceListPageProcessorFactory.list(this.accessor, page, (pageProcessor, handle) -> pageProcessor.createQuery((Handle)handle, conditions), this::toInfo, predicate, (items, token) -> new IcebergNamespaceListResponse(items.stream().map(IcebergNamespaceInfoEx::info).toList(), token));
    }

    @Override
    public Optional<IcebergNamespaceInfoEx> info(UUID catalogId, String namespaceName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_ICEBERG_NAMESPACE).bind("namespace_name", namespaceName)).map((rs, ctx) -> this.toInfo(rs)).findOne());
    }

    private IcebergNamespaceInfoEx toInfo(ResultSet rs) throws SQLException {
        IcebergNamespaceInfo info = new IcebergNamespaceInfo(rs.getString("catalog_name"), rs.getString("namespace_name"), rs.getString("namespace_owner_name"), JdbcUtils.stringToProperties(rs.getString("properties")));
        UUID catalogId = this.accessor.getUuid(rs, "catalog_id");
        Optional<UUID> catalogOwnerId = this.accessor.getOptionalUuid(rs, "catalog_owner_id");
        UUID namespaceId = this.accessor.getUuid(rs, "namespace_id");
        Optional<UUID> namespaceOwnerId = this.accessor.getOptionalUuid(rs, "namespace_owner_id");
        return new IcebergNamespaceInfoEx(catalogId, catalogOwnerId, namespaceId, namespaceOwnerId, info);
    }

    @Override
    public boolean updateOwnerIfExists(UUID namespaceId, UUID ownerId) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_ICEBERG_NAMESPACE_UPDATE_OWNER).bind("namespace_id", namespaceId)).bind("owner_id", ownerId)).execute() == 1);
    }
}

