/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogDetails;
import ru.cedrusdata.catalog.iceberg.catalog.IcebergCatalogInfoEx;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogFileSystemDoesNotExistException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergCatalogAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.iceberg.IcebergCatalogInUseException;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogInfo;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogListResponse;
import ru.cedrusdata.catalog.store.IcebergCatalogStore;
import ru.cedrusdata.catalog.store.StoreTracingInterceptor;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;
import ru.cedrusdata.catalog.store.jdbc.JdbcUtils;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorFactory;
import ru.cedrusdata.catalog.store.jdbc.PageSort;

@StoreTracingInterceptor.Traceable
public class JdbcIcebergCatalogStore
implements IcebergCatalogStore {
    @Language(value="SQL")
    private static final String SQL_ICEBERG_CATALOG_CREATE = "INSERT INTO metastore_catalog (\n    catalog_id,\n    catalog_name,\n    owner_id,\n    description,\n    file_system_id,\n    file_system_location,\n    properties)\nVALUES (\n    :catalog_id,\n    :catalog_name,\n    :owner_id,\n    :description,\n    :file_system_id,\n    :file_system_location,\n    :properties)\nON CONFLICT DO NOTHING";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_CATALOG_UPDATE = "UPDATE metastore_catalog\nSET\n    catalog_name = :catalog_name,\n    description = :description,\n    file_system_location = :file_system_location,\n    properties = :properties\nWHERE catalog_id = :catalog_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_CATALOG_UPDATE_OWNER = "UPDATE metastore_catalog\nSET owner_id = :owner_id\nWHERE catalog_id = :catalog_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_CATALOG_DELETE = "DELETE FROM metastore_catalog\nWHERE catalog_id = :catalog_id\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_CATALOG_DETAILS_ALL = "SELECT\n    c.catalog_id,\n    c.catalog_name,\n    c.owner_id,\n    c.description,\n    c.file_system_id,\n    c.file_system_location,\n    c.properties\nFROM metastore_catalog c\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_CATALOG_INFO = "SELECT\n    c.catalog_id,\n    c.catalog_name,\n    c.owner_id,\n    p.principal_name owner_name,\n    c.description,\n    fs.file_system_name,\n    c.file_system_location,\n    c.properties\nFROM metastore_catalog c\n    INNER JOIN metastore_file_system fs ON c.file_system_id = fs.file_system_id\n    LEFT OUTER JOIN metastore_principal p ON c.owner_id = p.principal_id\nWHERE c.catalog_name = :catalog_name\n";
    @Language(value="SQL")
    private static final String SQL_ICEBERG_CATALOG_INFO_LIST = "SELECT\n    c.catalog_id,\n    c.catalog_name,\n    c.owner_id,\n    p.principal_name owner_name,\n    c.description,\n    fs.file_system_name,\n    c.file_system_location,\n    c.properties\nFROM metastore_catalog c\n    INNER JOIN metastore_file_system fs ON c.file_system_id = fs.file_system_id\n    LEFT OUTER JOIN metastore_principal p ON c.owner_id = p.principal_id\n";
    private final JdbcAccessor accessor;
    private final PageProcessorFactory<IcebergCatalogInfoEx> icebergCatalogListPageProcessorFactory;

    @Inject
    public JdbcIcebergCatalogStore(JdbcAccessor accessor, CatalogStoreConfig config) {
        this.accessor = accessor;
        int maxPageSize = config.getStoreMaxPageSize();
        this.icebergCatalogListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_ICEBERG_CATALOG_INFO_LIST, PageSort.sort(PageSort.uuidSort("c.catalog_id", IcebergCatalogInfoEx::catalogId))), maxPageSize);
    }

    @Override
    public Optional<UUID> createIfNotExists(String catalogName, String description, UUID ownerId, UUID fileSystemId, String fileSystemName, Optional<String> fileSystemLocation, Map<String, String> properties) {
        try {
            UUID catalogId = UUID.randomUUID();
            return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_CATALOG_CREATE).bind("catalog_id", catalogId)).bind("catalog_name", catalogName)).bind("owner_id", ownerId)).bind("description", description)).bind("file_system_id", fileSystemId)).bind("file_system_location", (String)fileSystemLocation.orElse(null))).bind("properties", JdbcUtils.propertiesToString(properties))).execute() == 1 ? Optional.of(catalogId) : Optional.empty());
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new CatalogFileSystemDoesNotExistException(fileSystemName);
            }
            throw e;
        }
    }

    @Override
    public boolean updateIfExists(UUID catalogId, String catalogName, String description, Optional<String> fileSystemLocation, Map<String, String> properties) {
        try {
            return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_ICEBERG_CATALOG_UPDATE).bind("catalog_id", catalogId)).bind("catalog_name", catalogName)).bind("description", description)).bind("file_system_location", (String)fileSystemLocation.orElse(null))).bind("properties", JdbcUtils.propertiesToString(properties))).execute() == 1);
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new IcebergCatalogAlreadyExistsException(catalogName);
            }
            throw e;
        }
    }

    @Override
    public boolean updateOwnerIfExists(UUID catalogId, UUID ownerId) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_ICEBERG_CATALOG_UPDATE_OWNER).bind("catalog_id", catalogId)).bind("owner_id", ownerId)).execute() == 1);
    }

    @Override
    public boolean deleteIfExists(UUID catalogId, String catalogName) {
        try {
            return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_ICEBERG_CATALOG_DELETE).bind("catalog_id", catalogId)).execute() == 1);
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new IcebergCatalogInUseException(catalogName);
            }
            throw e;
        }
    }

    @Override
    public List<IcebergCatalogDetails> listDetails() {
        return this.accessor.execute(handle -> handle.createQuery(SQL_ICEBERG_CATALOG_DETAILS_ALL).map((rs, ctx) -> this.toDetails(rs)).list());
    }

    @Override
    public Optional<IcebergCatalogInfoEx> getInfo(String catalogName) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_ICEBERG_CATALOG_INFO).bind("catalog_name", catalogName)).map((rs, ctx) -> this.toInfo(rs)).findOne());
    }

    @Override
    public IcebergCatalogListResponse listInfo(ResultPage page, Predicate<IcebergCatalogInfoEx> predicate) {
        return this.icebergCatalogListPageProcessorFactory.list(this.accessor, page, this::toInfo, predicate, (items, nextPageToken) -> new IcebergCatalogListResponse(items.stream().map(IcebergCatalogInfoEx::info).toList(), nextPageToken));
    }

    private IcebergCatalogDetails toDetails(ResultSet rs) throws SQLException {
        return new IcebergCatalogDetails(this.accessor.getUuid(rs, "catalog_id"), rs.getString("catalog_name"), this.accessor.getOptionalUuid(rs, "owner_id"), rs.getString("description"), this.accessor.getUuid(rs, "file_system_id"), Optional.ofNullable(rs.getString("file_system_location")), JdbcUtils.stringToProperties(rs.getString("properties")));
    }

    private IcebergCatalogInfoEx toInfo(ResultSet rs) throws SQLException {
        IcebergCatalogInfo info = new IcebergCatalogInfo(rs.getString("catalog_name"), rs.getString("description"), rs.getString("owner_name"), rs.getString("file_system_name"), rs.getString("file_system_location"), JdbcUtils.stringToProperties(rs.getString("properties")));
        UUID catalogId = this.accessor.getUuid(rs, "catalog_id");
        Optional<UUID> ownerId = this.accessor.getOptionalUuid(rs, "owner_id");
        return new IcebergCatalogInfoEx(info, catalogId, ownerId);
    }
}

