/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.core.filesystem.FileSystemDetails;
import ru.cedrusdata.catalog.plugin.ExtensionPropertyClassifier;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogFileSystemAlreadyExistsException;
import ru.cedrusdata.catalog.spi.exception.CatalogFileSystemInUseException;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemType;
import ru.cedrusdata.catalog.spi.model.FileSystemListResponse;
import ru.cedrusdata.catalog.store.FileSystemStore;
import ru.cedrusdata.catalog.store.StoreTracingInterceptor;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;
import ru.cedrusdata.catalog.store.jdbc.JdbcUtils;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorFactory;
import ru.cedrusdata.catalog.store.jdbc.PageSort;

@StoreTracingInterceptor.Traceable
public class JdbcFileSystemStore
implements FileSystemStore {
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_CREATE = "INSERT INTO metastore_file_system (\n    file_system_id,\n    file_system_name,\n    file_system_type,\n    owner_id,\n    description,\n    properties)\nVALUES (\n    :file_system_id,\n    :file_system_name,\n    :file_system_type,\n    :owner_id,\n    :description,\n    :properties)\nON CONFLICT DO NOTHING";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_UPDATE = "UPDATE metastore_file_system\nSET\n    file_system_name = :file_system_name,\n    description = :description,\n    properties = :properties\nWHERE file_system_id = :file_system_id\n";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_UPDATE_OWNER = "UPDATE metastore_file_system\nSET owner_id = :owner_id\nWHERE file_system_id = :file_system_id\n";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_DELETE = "DELETE FROM metastore_file_system\nWHERE file_system_id = :file_system_id\n";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_DETAILS = "SELECT\n    fs.file_system_id,\n    fs.file_system_name,\n    fs.file_system_type,\n    fs.description,\n    fs.properties,\n    p.principal_id owner_id,\n    p.principal_name owner_name\nFROM metastore_file_system fs\n    LEFT OUTER JOIN metastore_principal p ON fs.owner_id = p.principal_id\nWHERE fs.file_system_name = :file_system_name\n";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_DETAILS_ALL = "SELECT\n    fs.file_system_id,\n    fs.file_system_name,\n    fs.file_system_type,\n    fs.description,\n    fs.properties,\n    p.principal_id owner_id,\n    p.principal_name owner_name\nFROM metastore_file_system fs\n    LEFT OUTER JOIN metastore_principal p ON fs.owner_id = p.principal_id\n";
    @Language(value="SQL")
    private static final String SQL_FILE_SYSTEM_LIST = "SELECT\n    fs.file_system_id,\n    fs.file_system_name,\n    fs.file_system_type,\n    fs.description,\n    fs.properties,\n    p.principal_id owner_id,\n    p.principal_name owner_name\nFROM metastore_file_system fs\n    LEFT OUTER JOIN metastore_principal p ON fs.owner_id = p.principal_id\n";
    private final JdbcAccessor accessor;
    private final PageProcessorFactory<FileSystemDetails> fileSystemListPageProcessorFactory;

    @Inject
    public JdbcFileSystemStore(JdbcAccessor accessor, CatalogStoreConfig config) {
        this.accessor = accessor;
        int maxPageSize = config.getStoreMaxPageSize();
        this.fileSystemListPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder("SELECT\n    fs.file_system_id,\n    fs.file_system_name,\n    fs.file_system_type,\n    fs.description,\n    fs.properties,\n    p.principal_id owner_id,\n    p.principal_name owner_name\nFROM metastore_file_system fs\n    LEFT OUTER JOIN metastore_principal p ON fs.owner_id = p.principal_id\n", PageSort.sort(PageSort.uuidSort("file_system_id", FileSystemDetails::id))), maxPageSize);
    }

    @Override
    public boolean createFileSystemIfNotExists(UUID id, UUID ownerId, String name, String description, CatalogFileSystemType fileSystemType, Map<String, String> properties) {
        return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_FILE_SYSTEM_CREATE).bind("file_system_id", id)).bind("file_system_name", name)).bind("file_system_type", fileSystemType.name())).bind("owner_id", ownerId)).bind("description", description)).bind("properties", JdbcUtils.propertiesToString(properties))).execute() == 1);
    }

    @Override
    public boolean updateFileSystemIfExists(UUID id, String name, String description, Map<String, String> properties) {
        try {
            return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)handle.createUpdate(SQL_FILE_SYSTEM_UPDATE).bind("file_system_id", id)).bind("file_system_name", name)).bind("description", description)).bind("properties", JdbcUtils.propertiesToString(properties))).execute() == 1);
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new CatalogFileSystemAlreadyExistsException(name);
            }
            throw e;
        }
    }

    @Override
    public boolean updateOwner(UUID id, UUID ownerId) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_FILE_SYSTEM_UPDATE_OWNER).bind("file_system_id", id)).bind("owner_id", ownerId)).execute() == 1);
    }

    @Override
    public boolean deleteFileSystemIfExists(UUID id, String name) {
        try {
            return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_FILE_SYSTEM_DELETE).bind("file_system_id", id)).execute() == 1);
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new CatalogFileSystemInUseException(name);
            }
            throw e;
        }
    }

    @Override
    public Optional<FileSystemDetails> fileSystemDetails(String name) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_FILE_SYSTEM_DETAILS).bind("file_system_name", name)).map((rs, ctx) -> this.toFileSystemDetails(rs)).findOne());
    }

    @Override
    public List<FileSystemDetails> fileSystemAllDetails() {
        return this.accessor.execute(handle -> handle.createQuery("SELECT\n    fs.file_system_id,\n    fs.file_system_name,\n    fs.file_system_type,\n    fs.description,\n    fs.properties,\n    p.principal_id owner_id,\n    p.principal_name owner_name\nFROM metastore_file_system fs\n    LEFT OUTER JOIN metastore_principal p ON fs.owner_id = p.principal_id\n").map((rs, ctx) -> this.toFileSystemDetails(rs)).list());
    }

    @Override
    public FileSystemListResponse listFileSystems(ResultPage page, ExtensionPropertyClassifier<CatalogFileSystemType> propertyClassifier, Predicate<FileSystemDetails> predicate) {
        return this.fileSystemListPageProcessorFactory.list(this.accessor, page, this::toFileSystemDetails, predicate, (items, nextPageToken) -> new FileSystemListResponse(items.stream().map(info -> info.toInfo(propertyClassifier)).toList(), nextPageToken));
    }

    private FileSystemDetails toFileSystemDetails(ResultSet rs) throws SQLException {
        return new FileSystemDetails(this.accessor.getUuid(rs, "file_system_id"), rs.getString("file_system_name"), this.accessor.getOptionalUuid(rs, "owner_id"), Optional.ofNullable(rs.getString("owner_name")), rs.getString("description"), CatalogUtils.resolveFileSystemType(rs.getString("file_system_type")), JdbcUtils.stringToProperties(rs.getString("properties")));
    }
}

