/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.store.jdbc;

import com.google.inject.Inject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import org.intellij.lang.annotations.Language;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import ru.cedrusdata.catalog.config.store.CatalogStoreConfig;
import ru.cedrusdata.catalog.core.computeengine.ComputeEngineDetails;
import ru.cedrusdata.catalog.plugin.ExtensionPropertyClassifier;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineType;
import ru.cedrusdata.catalog.spi.exception.CatalogComputeEngineAlreadyExistsException;
import ru.cedrusdata.catalog.spi.model.ComputeEngineListResponse;
import ru.cedrusdata.catalog.spi.model.ComputeEngineOperationMetadata;
import ru.cedrusdata.catalog.store.ComputeEngineStore;
import ru.cedrusdata.catalog.store.StoreTracingInterceptor;
import ru.cedrusdata.catalog.store.jdbc.JdbcAccessor;
import ru.cedrusdata.catalog.store.jdbc.JdbcUtils;
import ru.cedrusdata.catalog.store.jdbc.ListQueryBuilder;
import ru.cedrusdata.catalog.store.jdbc.PageProcessorFactory;
import ru.cedrusdata.catalog.store.jdbc.PageSort;

@StoreTracingInterceptor.Traceable
public class JdbcComputeEngineStore
implements ComputeEngineStore {
    @Language(value="SQL")
    private static final String SQL_DELETE_BY_ID = "DELETE FROM metastore_compute_engine\nWHERE engine_id = :engine_id\n";
    @Language(value="SQL")
    private static final String SQL_LIST = "SELECT\n    e.engine_id,\n    e.engine_name,\n    e.engine_type,\n    e.description,\n    e.properties,\n    e.owner_id,\n    p.principal_name owner_name\nFROM metastore_compute_engine e\n    LEFT OUTER JOIN metastore_principal p ON e.owner_id = p.principal_id\n";
    @Language(value="SQL")
    private static final String SQL_GET_BY_NAME = "SELECT\n    e.engine_id,\n    e.engine_name,\n    e.engine_type,\n    e.description,\n    e.properties,\n    e.owner_id,\n    p.principal_name owner_name\nFROM metastore_compute_engine e\n    LEFT OUTER JOIN metastore_principal p ON e.owner_id = p.principal_id\nWHERE engine_name = :engine_name\n";
    @Language(value="SQL")
    private static final String SQL_CREATE = "INSERT INTO metastore_compute_engine (\n    engine_id,\n    engine_name,\n    engine_type,\n    description,\n    properties,\n    owner_id)\nVALUES (\n    :engine_id,\n    :engine_name,\n    :engine_type,\n    :description,\n    :properties,\n    :owner_id)\nON CONFLICT DO NOTHING";
    @Language(value="SQL")
    private static final String SQL_UPDATE_BY_ID = "UPDATE metastore_compute_engine\nSET\n    engine_name = :engine_name,\n    description = :description,\n    properties = :properties\nWHERE engine_id = :engine_id\n";
    @Language(value="SQL")
    private static final String SQL_UPDATE_OWNER = "UPDATE metastore_compute_engine\nSET owner_id = :owner_id\nWHERE engine_id = :engine_id\n";
    private final JdbcAccessor accessor;
    private final PageProcessorFactory<ComputeEngineDetails> listPageProcessorFactory;

    @Inject
    public JdbcComputeEngineStore(JdbcAccessor accessor, CatalogStoreConfig config) {
        this.accessor = accessor;
        this.listPageProcessorFactory = new PageProcessorFactory(ListQueryBuilder.createQueryBuilder(SQL_LIST, PageSort.sort(PageSort.uuidSort("engine_id", ComputeEngineDetails::id))), config.getStoreMaxPageSize());
    }

    @Override
    public boolean createEngineIfNotExists(UUID id, String name, String description, CatalogComputeEngineType type, Map<String, String> properties, UUID ownerId) {
        return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)((Update)((Update)handle.createUpdate(SQL_CREATE).bind("engine_id", id)).bind("engine_name", name)).bind("engine_type", type.getIdentifier())).bind("description", description)).bind("properties", JdbcUtils.propertiesToString(properties))).bind("owner_id", ownerId)).execute() == 1);
    }

    @Override
    public Optional<ComputeEngineDetails> engineDetails(String name) {
        return this.accessor.execute(handle -> ((Query)handle.createQuery(SQL_GET_BY_NAME).bind("engine_name", name)).map((rs, ctx) -> this.toComputeEngineDetails(rs)).findOne());
    }

    @Override
    public ComputeEngineListResponse listEngines(ResultPage page, ExtensionPropertyClassifier<CatalogComputeEngineType> enginePropertyClassifier, Predicate<ComputeEngineDetails> predicate, Function<ComputeEngineDetails, List<ComputeEngineOperationMetadata>> engineOperations) {
        return this.listPageProcessorFactory.list(this.accessor, page, this::toComputeEngineDetails, predicate, (items, nextPageToken) -> new ComputeEngineListResponse(items.stream().map(details -> details.info(enginePropertyClassifier, (List)engineOperations.apply((ComputeEngineDetails)details))).toList(), nextPageToken));
    }

    @Override
    public List<ComputeEngineDetails> engineAllDetails() {
        return this.accessor.execute(handle -> handle.createQuery(SQL_LIST).map((rs, ctx) -> this.toComputeEngineDetails(rs)).list());
    }

    @Override
    public boolean deleteEngineIfExists(UUID id) {
        return this.accessor.execute(handle -> ((Update)handle.createUpdate(SQL_DELETE_BY_ID).bind("engine_id", id)).execute() == 1);
    }

    @Override
    public boolean updateEngineIfExists(UUID id, String name, String description, Map<String, String> properties) {
        try {
            return this.accessor.execute(handle -> ((Update)((Update)((Update)((Update)handle.createUpdate(SQL_UPDATE_BY_ID).bind("engine_id", id)).bind("engine_name", name)).bind("description", description)).bind("properties", JdbcUtils.propertiesToString(properties))).execute() == 1);
        }
        catch (Exception e) {
            if (this.accessor.isConstraintViolationException(e)) {
                throw new CatalogComputeEngineAlreadyExistsException(name);
            }
            throw e;
        }
    }

    @Override
    public boolean updateOwner(UUID id, UUID ownerId) {
        return this.accessor.execute(handle -> ((Update)((Update)handle.createUpdate(SQL_UPDATE_OWNER).bind("engine_id", id)).bind("owner_id", ownerId)).execute() == 1);
    }

    private ComputeEngineDetails toComputeEngineDetails(ResultSet rs) throws SQLException {
        return new ComputeEngineDetails(this.accessor.getUuid(rs, "engine_id"), rs.getString("engine_name"), rs.getString("description"), CatalogComputeEngineType.resolve((int)rs.getInt("engine_type")), JdbcUtils.stringToProperties(rs.getString("properties")), this.accessor.getOptionalUuid(rs, "owner_id"), Optional.ofNullable(rs.getString("owner_name")));
    }
}

