/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server.rest;

import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import ru.cedrusdata.catalog.CatalogObjectNameValidation;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.api.EmbeddedInternalCatalogClientFactory;
import ru.cedrusdata.catalog.core.principal.AuthenticationContext;
import ru.cedrusdata.catalog.spi.client.ResultPage;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateRequest;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateTemporaryResponse;
import ru.cedrusdata.catalog.spi.model.AccessTokenListResponse;
import ru.cedrusdata.catalog.spi.model.CheckAccessRequest;
import ru.cedrusdata.catalog.spi.model.CheckAccessResponse;
import ru.cedrusdata.catalog.spi.model.ComputeEngineCheckResponse;
import ru.cedrusdata.catalog.spi.model.ComputeEngineCreateRequest;
import ru.cedrusdata.catalog.spi.model.ComputeEngineInfo;
import ru.cedrusdata.catalog.spi.model.ComputeEngineListResponse;
import ru.cedrusdata.catalog.spi.model.ComputeEngineUpdateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemCheckResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemCreateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;
import ru.cedrusdata.catalog.spi.model.FileSystemListResponse;
import ru.cedrusdata.catalog.spi.model.FileSystemUpdateRequest;
import ru.cedrusdata.catalog.spi.model.GrantOwnershipRequest;
import ru.cedrusdata.catalog.spi.model.GrantPrivilegeRequest;
import ru.cedrusdata.catalog.spi.model.GrantRoleRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCheckResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCreateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogInfo;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCteTableForReuseRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCteTableForReuseResponse;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceInfo;
import ru.cedrusdata.catalog.spi.model.IcebergNamespaceListResponse;
import ru.cedrusdata.catalog.spi.model.IcebergObjectInfo;
import ru.cedrusdata.catalog.spi.model.IcebergObjectListResponse;
import ru.cedrusdata.catalog.spi.model.LabelListResponse;
import ru.cedrusdata.catalog.spi.model.LocaleListResponse;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobCreateRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobInfo;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobListResponse;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobUpdateRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationInfo;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationListResponse;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationStartRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationStartResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupCreateRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupInfo;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemAddRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupObjectListResponse;
import ru.cedrusdata.catalog.spi.model.ObjectGroupUpdateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalCreateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalInfo;
import ru.cedrusdata.catalog.spi.model.PrincipalListResponse;
import ru.cedrusdata.catalog.spi.model.PrincipalUpdateRequest;
import ru.cedrusdata.catalog.spi.model.PrivilegeGrantsResponse;
import ru.cedrusdata.catalog.spi.model.PrivilegeTypesResponse;
import ru.cedrusdata.catalog.spi.model.PrivilegedActionsResponse;
import ru.cedrusdata.catalog.spi.model.RevokePrivilegeRequest;
import ru.cedrusdata.catalog.spi.model.RevokeRoleRequest;
import ru.cedrusdata.catalog.spi.model.RoleMembersResponse;
import ru.cedrusdata.catalog.spi.model.SecurablePrivilegeGrantsRequest;
import ru.cedrusdata.catalog.spi.model.SecurableTypesResponse;
import ru.cedrusdata.catalog.spi.model.SecurityProviderCheckResponse;
import ru.cedrusdata.catalog.spi.model.SecurityProviderCreateRequest;
import ru.cedrusdata.catalog.spi.model.SecurityProviderInfo;
import ru.cedrusdata.catalog.spi.model.SecurityProviderListResponse;
import ru.cedrusdata.catalog.spi.model.SecurityProviderUpdateRequest;
import ru.cedrusdata.catalog.spi.model.UpdateResponse;

public class V1ApiImpl {
    private static final JsonCodec<Map<String, Object>> FILTER_CODEC = JsonCodec.mapJsonCodec(String.class, Object.class);
    private final EmbeddedInternalCatalogClientFactory clientFactory;

    @Inject
    public V1ApiImpl(EmbeddedInternalCatalogClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public Response createPrincipal(AuthenticationContext principal, PrincipalCreateRequest request) {
        this.clientFactory.createClient(principal).createPrincipal(request);
        return Response.noContent().build();
    }

    public Response updatePrincipal(AuthenticationContext context, String principalName, PrincipalUpdateRequest request) {
        principalName = CatalogObjectNameValidation.VALIDATION_PRINCIPAL.decodeString(principalName);
        this.clientFactory.createClient(context).updatePrincipal(principalName, request);
        return Response.noContent().build();
    }

    public Response deletePrincipal(AuthenticationContext context, String principalName) {
        principalName = CatalogObjectNameValidation.VALIDATION_PRINCIPAL.decodeString(principalName);
        this.clientFactory.createClient(context).deletePrincipal(principalName);
        return Response.noContent().build();
    }

    public Response getPrincipal(AuthenticationContext context, String principalName) {
        principalName = CatalogObjectNameValidation.VALIDATION_PRINCIPAL.decodeString(principalName);
        PrincipalInfo result = this.clientFactory.createClient(context).getPrincipal(principalName);
        return Response.ok((Object)result).build();
    }

    public Response listPrincipals(AuthenticationContext context, String principalType, Boolean principalActive, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        PrincipalListResponse result = this.clientFactory.createClient(context).listPrincipals(Optional.ofNullable(principalType), principalActive != null ? Optional.of(principalActive) : Optional.empty(), page);
        return Response.ok((Object)result).build();
    }

    public Response createTemporaryAccessToken(AuthenticationContext context, String subject) {
        subject = CatalogObjectNameValidation.VALIDATION_PRINCIPAL.decodeString(subject);
        AccessTokenCreateTemporaryResponse result = this.clientFactory.createClient(context).createTemporaryAccessToken(subject);
        return Response.ok((Object)result).build();
    }

    public Response createTemporaryAccessTokenForSelf(AuthenticationContext context) {
        AccessTokenCreateTemporaryResponse result = this.clientFactory.createClient(context).createTemporaryAccessToken();
        return Response.ok((Object)result).build();
    }

    public Response createAccessToken(AuthenticationContext context, AccessTokenCreateRequest request) {
        AccessTokenCreateResponse response = this.clientFactory.createClient(context).createAccessToken(request);
        return Response.ok((Object)response).build();
    }

    public Response deleteAccessToken(AuthenticationContext context, String accessTokenId) {
        this.clientFactory.createClient(context).deleteAccessToken(accessTokenId);
        return Response.noContent().build();
    }

    public Response listAccessTokens(AuthenticationContext context, String principalName, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        AccessTokenListResponse response = this.clientFactory.createClient(context).listAccessTokens(CatalogObjectNameValidation.VALIDATION_PRINCIPAL.decodeOptionalString(principalName), page);
        return Response.ok((Object)response).build();
    }

    public Response grantRole(AuthenticationContext context, GrantRoleRequest request) {
        UpdateResponse response = this.clientFactory.createClient(context).grantRole(request);
        return Response.ok((Object)response).build();
    }

    public Response revokeRole(AuthenticationContext context, RevokeRoleRequest request) {
        UpdateResponse response = this.clientFactory.createClient(context).revokeRole(request);
        return Response.ok((Object)response).build();
    }

    public Response roleMembers(AuthenticationContext context, String roleName) {
        RoleMembersResponse response = this.clientFactory.createClient(context).roleMembers(roleName);
        return Response.ok((Object)response).build();
    }

    public Response grantPrivilege(AuthenticationContext context, GrantPrivilegeRequest request) {
        UpdateResponse response = this.clientFactory.createClient(context).grantPrivilege(request);
        return Response.ok((Object)response).build();
    }

    public Response revokePrivilege(AuthenticationContext context, RevokePrivilegeRequest request) {
        UpdateResponse response = this.clientFactory.createClient(context).revokePrivilege(request);
        return Response.ok((Object)response).build();
    }

    public Response principalPrivilegeGrants(AuthenticationContext context, String principal) {
        PrivilegeGrantsResponse response = this.clientFactory.createClient(context).principalPrivilegeGrants(principal);
        return Response.ok((Object)response).build();
    }

    public Response securablePrivilegeGrants(AuthenticationContext context, SecurablePrivilegeGrantsRequest request) {
        PrivilegeGrantsResponse response = this.clientFactory.createClient(context).securablePrivilegeGrants(request);
        return Response.ok((Object)response).build();
    }

    public Response grantOwnership(AuthenticationContext context, GrantOwnershipRequest request) {
        UpdateResponse response = this.clientFactory.createClient(context).grantOwnership(request);
        return Response.ok((Object)response).build();
    }

    public Response securableTypes(AuthenticationContext context) {
        SecurableTypesResponse response = this.clientFactory.createClient(context).securableTypes();
        return Response.ok((Object)response).build();
    }

    public Response privilegeTypes(AuthenticationContext context) {
        PrivilegeTypesResponse response = this.clientFactory.createClient(context).privilegeTypes();
        return Response.ok((Object)response).build();
    }

    public Response privilegedActions(AuthenticationContext context) {
        PrivilegedActionsResponse response = this.clientFactory.createClient(context).privilegedActions();
        return Response.ok((Object)response).build();
    }

    public Response checkAccess(AuthenticationContext context, CheckAccessRequest request) {
        CheckAccessResponse response = this.clientFactory.createClient(context).checkAccess(request);
        return Response.ok((Object)response).build();
    }

    public Response createFileSystem(AuthenticationContext context, FileSystemCreateRequest request) {
        this.clientFactory.createClient(context).createFileSystem(request);
        return Response.noContent().build();
    }

    public Response updateFileSystem(AuthenticationContext context, String fileSystem, FileSystemUpdateRequest request) {
        fileSystem = CatalogObjectNameValidation.VALIDATION_FILE_SYSTEM.decodeString(fileSystem);
        this.clientFactory.createClient(context).updateFileSystem(fileSystem, request);
        return Response.noContent().build();
    }

    public Response deleteFileSystem(AuthenticationContext context, String fileSystem) {
        fileSystem = CatalogObjectNameValidation.VALIDATION_FILE_SYSTEM.decodeString(fileSystem);
        this.clientFactory.createClient(context).deleteFileSystem(fileSystem);
        return Response.noContent().build();
    }

    public Response getFileSystem(AuthenticationContext context, String fileSystem) {
        fileSystem = CatalogObjectNameValidation.VALIDATION_FILE_SYSTEM.decodeString(fileSystem);
        FileSystemInfo response = this.clientFactory.createClient(context).getFileSystem(fileSystem);
        return Response.ok((Object)response).build();
    }

    public Response listFileSystems(AuthenticationContext context, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        FileSystemListResponse result = this.clientFactory.createClient(context).listFileSystems(page);
        return Response.ok((Object)result).build();
    }

    public Response checkFileSystem(AuthenticationContext principal, String fileSystem) {
        FileSystemCheckResponse result = this.clientFactory.createClient(principal).checkFileSystem(fileSystem);
        return Response.ok((Object)result).build();
    }

    public Response createIcebergCatalog(AuthenticationContext principal, IcebergCatalogCreateRequest request) {
        this.clientFactory.createClient(principal).createIcebergCatalog(request);
        return Response.noContent().build();
    }

    public Response updateIcebergCatalog(AuthenticationContext principal, String catalog, IcebergCatalogUpdateRequest request) {
        catalog = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalog);
        this.clientFactory.createClient(principal).updateIcebergCatalog(catalog, request);
        return Response.noContent().build();
    }

    public Response deleteIcebergCatalog(AuthenticationContext principal, String catalog) {
        catalog = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalog);
        this.clientFactory.createClient(principal).deleteIcebergCatalog(catalog);
        return Response.noContent().build();
    }

    public Response getIcebergCatalog(AuthenticationContext principal, String catalog) {
        catalog = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalog);
        IcebergCatalogInfo response = this.clientFactory.createClient(principal).getIcebergCatalog(catalog);
        return Response.ok((Object)response).build();
    }

    public Response listIcebergCatalogs(AuthenticationContext context, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        IcebergCatalogListResponse result = this.clientFactory.createClient(context).listIcebergCatalogs(page);
        return Response.ok((Object)result).build();
    }

    public Response checkIcebergCatalog(AuthenticationContext principal, String catalog) {
        IcebergCatalogCheckResponse result = this.clientFactory.createClient(principal).checkIcebergCatalog(catalog);
        return Response.ok((Object)result).build();
    }

    public Response getIcebergNamespace(AuthenticationContext context, String catalog, String namespace) {
        catalog = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalog);
        namespace = CatalogUtils.flattenIcebergNamespace(CatalogObjectNameValidation.decodeIcebergNamespace(namespace));
        IcebergNamespaceInfo response = this.clientFactory.createClient(context).getIcebergNamespace(catalog, namespace);
        return Response.ok((Object)response).build();
    }

    public Response listIcebergNamespaces(AuthenticationContext context, String catalog, String pageToken, Integer pageSize) {
        Optional<String> optionalCatalog = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeOptionalString(catalog);
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        IcebergNamespaceListResponse result = this.clientFactory.createClient(context).listIcebergNamespaces(optionalCatalog, page);
        return Response.ok((Object)result).build();
    }

    public Response getIcebergObject(AuthenticationContext context, String catalog, String namespace, String object) {
        catalog = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalog);
        namespace = CatalogUtils.flattenIcebergNamespace(CatalogObjectNameValidation.decodeIcebergNamespace(namespace));
        object = CatalogObjectNameValidation.VALIDATION_OBJECT.decodeString(object);
        IcebergObjectInfo response = this.clientFactory.createClient(context).getIcebergObject(catalog, namespace, object);
        return Response.ok((Object)response).build();
    }

    public Response listIcebergObjects(AuthenticationContext context, String catalog, String namespaceName, String objectType, String pageToken, Integer pageSize) {
        Optional<String> optionalCatalog = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeOptionalString(catalog);
        Optional<String> optionalNamespace = CatalogObjectNameValidation.decodeOptionalIcebergNamespace(namespaceName).map(CatalogUtils::flattenIcebergNamespace);
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        IcebergObjectListResponse result = this.clientFactory.createClient(context).listIcebergObjects(optionalCatalog, optionalNamespace, Optional.ofNullable(objectType), page);
        return Response.ok((Object)result).build();
    }

    public Response listMaterializedViewsForRewrite(AuthenticationContext context, String catalog, IcebergMaterializedViewForRewriteListRequest request) {
        catalog = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalog);
        IcebergMaterializedViewForRewriteListResponse result = this.clientFactory.createClient(context).listMaterializedViewsForRewrite(catalog, request);
        return Response.ok((Object)result).build();
    }

    public Response getCteTableForReuse(AuthenticationContext context, String catalog, IcebergCteTableForReuseRequest request) {
        catalog = CatalogObjectNameValidation.VALIDATION_CATALOG.decodeString(catalog);
        IcebergCteTableForReuseResponse result = this.clientFactory.createClient(context).getCteTableForReuse(catalog, request);
        return Response.ok((Object)result).build();
    }

    public Response checkComputeEngine(AuthenticationContext context, String computeEngineName) {
        ComputeEngineCheckResponse result = this.clientFactory.createClient(context).checkComputeEngine(computeEngineName);
        return Response.ok((Object)result).build();
    }

    public Response createComputeEngine(AuthenticationContext context, ComputeEngineCreateRequest request) {
        this.clientFactory.createClient(context).createComputeEngine(request);
        return Response.noContent().build();
    }

    public Response updateComputeEngine(AuthenticationContext context, String computeEngineName, ComputeEngineUpdateRequest request) {
        computeEngineName = CatalogObjectNameValidation.VALIDATION_COMPUTE_ENGINE.decodeString(computeEngineName);
        this.clientFactory.createClient(context).updateComputeEngine(computeEngineName, request);
        return Response.noContent().build();
    }

    public Response startMaintenanceOperation(AuthenticationContext context, MaintenanceOperationStartRequest request) {
        MaintenanceOperationStartResponse response = this.clientFactory.createClient(context).startMaintenanceOperation(request);
        return Response.ok((Object)response).build();
    }

    public Response getMaintenanceOperation(AuthenticationContext context, UUID operationId) {
        MaintenanceOperationInfo response = this.clientFactory.createClient(context).getMaintenanceOperation(operationId);
        return Response.ok((Object)response).build();
    }

    public Response cancelMaintenanceOperation(AuthenticationContext context, UUID operationId) {
        this.clientFactory.createClient(context).cancelMaintenanceOperation(operationId);
        return Response.noContent().build();
    }

    public Response listMaintenanceOperations(AuthenticationContext context, String pageToken, Integer pageSize, String filter) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        MaintenanceOperationListResponse response = this.clientFactory.createClient(context).listMaintenanceOperations(page, V1ApiImpl.parseFilter(filter));
        return Response.ok((Object)response).build();
    }

    public Response getComputeEngine(AuthenticationContext context, String computeEngineName) {
        computeEngineName = CatalogObjectNameValidation.VALIDATION_COMPUTE_ENGINE.decodeString(computeEngineName);
        ComputeEngineInfo response = this.clientFactory.createClient(context).getComputeEngine(computeEngineName);
        return Response.ok((Object)response).build();
    }

    public Response listComputeEngines(AuthenticationContext context, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        ComputeEngineListResponse result = this.clientFactory.createClient(context).listComputeEngines(page);
        return Response.ok((Object)result).build();
    }

    public Response deleteComputeEngine(AuthenticationContext context, String computeEngineName) {
        computeEngineName = CatalogObjectNameValidation.VALIDATION_COMPUTE_ENGINE.decodeString(computeEngineName);
        this.clientFactory.createClient(context).deleteComputeEngine(computeEngineName);
        return null;
    }

    public Response createObjectGroup(AuthenticationContext context, ObjectGroupCreateRequest request) {
        this.clientFactory.createClient(context).createObjectGroup(request);
        return Response.noContent().build();
    }

    public Response updateObjectGroup(AuthenticationContext context, String objectGroupName, ObjectGroupUpdateRequest request) {
        this.clientFactory.createClient(context).updateObjectGroup(objectGroupName, request);
        return Response.noContent().build();
    }

    public Response deleteObjectGroup(AuthenticationContext context, String objectGroupName) {
        this.clientFactory.createClient(context).deleteObjectGroup(objectGroupName);
        return Response.noContent().build();
    }

    public Response getObjectGroup(AuthenticationContext context, String objectGroupName) {
        ObjectGroupInfo response = this.clientFactory.createClient(context).getObjectGroup(objectGroupName);
        return Response.ok((Object)response).build();
    }

    public Response listObjectGroups(AuthenticationContext context, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        ObjectGroupListResponse result = this.clientFactory.createClient(context).listObjectGroups(page);
        return Response.ok((Object)result).build();
    }

    public Response listObjectGroupObjects(AuthenticationContext context, String objectGroupName, UUID itemId, String objectType, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        ObjectGroupObjectListResponse result = this.clientFactory.createClient(context).listObjectGroupObjects(objectGroupName, Optional.ofNullable(itemId), Optional.ofNullable(objectType), page);
        return Response.ok((Object)result).build();
    }

    public Response addObjectGroupItem(AuthenticationContext context, String objectGroupName, ObjectGroupItemAddRequest request) {
        this.clientFactory.createClient(context).addObjectGroupItem(objectGroupName, request);
        return Response.noContent().build();
    }

    public Response deleteObjectGroupItem(AuthenticationContext context, String objectGroupName, UUID itemId) {
        this.clientFactory.createClient(context).deleteObjectGroupItem(objectGroupName, itemId);
        return Response.noContent().build();
    }

    public Response listObjectGroupItems(AuthenticationContext context, String objectGroupName, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        ObjectGroupItemListResponse result = this.clientFactory.createClient(context).listObjectGroupItems(objectGroupName, page);
        return Response.ok((Object)result).build();
    }

    public Response createMaintenanceJob(AuthenticationContext context, MaintenanceJobCreateRequest request) {
        this.clientFactory.createClient(context).createMaintenanceJob(request);
        return Response.noContent().build();
    }

    public Response updateMaintenanceJob(AuthenticationContext context, String jobName, MaintenanceJobUpdateRequest request) {
        this.clientFactory.createClient(context).updateMaintenanceJob(jobName, request);
        return Response.noContent().build();
    }

    public Response deleteMaintenanceJob(AuthenticationContext context, String jobName) {
        this.clientFactory.createClient(context).deleteMaintenanceJob(jobName);
        return Response.noContent().build();
    }

    public Response getMaintenanceJob(AuthenticationContext context, String jobName) {
        MaintenanceJobInfo result = this.clientFactory.createClient(context).getMaintenanceJob(jobName);
        return Response.ok((Object)result).build();
    }

    public Response listMaintenanceJobs(AuthenticationContext context, String pageToken, Integer pageSize, String filter) {
        MaintenanceJobListResponse result = this.clientFactory.createClient(context).listMaintenanceJobs(ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize), V1ApiImpl.parseFilter(filter));
        return Response.ok((Object)result).build();
    }

    public Response listLocales(AuthenticationContext context) {
        LocaleListResponse response = this.clientFactory.createClient(context).listLocales();
        return Response.ok((Object)response).build();
    }

    public Response listLabels(AuthenticationContext context, String locale) {
        LabelListResponse response = this.clientFactory.createClient(context).listLabels(V1ApiImpl.parseLocale(locale));
        return Response.ok((Object)response).build();
    }

    public Response checkSecurityProvider(AuthenticationContext context, String securityProviderName) {
        SecurityProviderCheckResponse result = this.clientFactory.createClient(context).checkSecurityProvider(securityProviderName);
        return Response.ok((Object)result).build();
    }

    public Response createSecurityProvider(AuthenticationContext context, SecurityProviderCreateRequest request) {
        this.clientFactory.createClient(context).createSecurityProvider(request);
        return Response.noContent().build();
    }

    public Response updateSecurityProvider(AuthenticationContext context, String securityProviderName, SecurityProviderUpdateRequest request) {
        securityProviderName = CatalogObjectNameValidation.VALIDATION_SECURITY_PROVIDER.decodeString(securityProviderName);
        UpdateResponse response = this.clientFactory.createClient(context).updateSecurityProvider(securityProviderName, request);
        return Response.ok((Object)response).build();
    }

    public Response getSecurityProvider(AuthenticationContext context, String securityProviderName) {
        securityProviderName = CatalogObjectNameValidation.VALIDATION_SECURITY_PROVIDER.decodeString(securityProviderName);
        SecurityProviderInfo response = this.clientFactory.createClient(context).getSecurityProvider(securityProviderName);
        return Response.ok((Object)response).build();
    }

    public Response listSecurityProviders(AuthenticationContext context, String pageToken, Integer pageSize) {
        ResultPage page = ResultPage.fromQueryParams((String)pageToken, (Integer)pageSize);
        SecurityProviderListResponse result = this.clientFactory.createClient(context).listSecurityProviders(page);
        return Response.ok((Object)result).build();
    }

    public Response deleteSecurityProvider(AuthenticationContext context, String securityProviderName) {
        securityProviderName = CatalogObjectNameValidation.VALIDATION_SECURITY_PROVIDER.decodeString(securityProviderName);
        this.clientFactory.createClient(context).deleteSecurityProvider(securityProviderName);
        return null;
    }

    private static Optional<Map<String, Object>> parseFilter(String filter) {
        if (filter == null || filter.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.ofNullable((Map)FILTER_CODEC.fromJson(filter));
        }
        catch (IllegalArgumentException e) {
            throw new CatalogBadRequestException(String.format("Invalid filter \"%s\"", filter));
        }
    }

    private static Locale parseLocale(String locale) {
        List<Object> locales = List.of();
        if (locale != null && !locale.isEmpty()) {
            try {
                locales = Locale.LanguageRange.parse(locale).stream().map(range -> Locale.forLanguageTag(range.getRange())).toList();
            }
            catch (IllegalArgumentException e) {
                throw new CatalogBadRequestException(String.format("Invalid locale \"%s\"", locale));
            }
        }
        if (locales.isEmpty()) {
            throw new CatalogBadRequestException("Locale can not be empty");
        }
        return (Locale)locales.getFirst();
    }
}

