/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.server.rest;

import com.google.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.UUID;
import ru.cedrusdata.catalog.CatalogUtils;
import ru.cedrusdata.catalog.server.rest.V1ApiImpl;
import ru.cedrusdata.catalog.server.security.ResourceSecurity;
import ru.cedrusdata.catalog.server.security.ResourceType;
import ru.cedrusdata.catalog.spi.model.AccessTokenCreateRequest;
import ru.cedrusdata.catalog.spi.model.CheckAccessRequest;
import ru.cedrusdata.catalog.spi.model.ComputeEngineCreateRequest;
import ru.cedrusdata.catalog.spi.model.ComputeEngineUpdateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemCreateRequest;
import ru.cedrusdata.catalog.spi.model.FileSystemUpdateRequest;
import ru.cedrusdata.catalog.spi.model.GrantOwnershipRequest;
import ru.cedrusdata.catalog.spi.model.GrantPrivilegeRequest;
import ru.cedrusdata.catalog.spi.model.GrantRoleRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogCreateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCatalogUpdateRequest;
import ru.cedrusdata.catalog.spi.model.IcebergCteTableForReuseRequest;
import ru.cedrusdata.catalog.spi.model.IcebergMaterializedViewForRewriteListRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobCreateRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceJobUpdateRequest;
import ru.cedrusdata.catalog.spi.model.MaintenanceOperationStartRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupCreateRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupItemAddRequest;
import ru.cedrusdata.catalog.spi.model.ObjectGroupUpdateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalCreateRequest;
import ru.cedrusdata.catalog.spi.model.PrincipalUpdateRequest;
import ru.cedrusdata.catalog.spi.model.RevokePrivilegeRequest;
import ru.cedrusdata.catalog.spi.model.RevokeRoleRequest;
import ru.cedrusdata.catalog.spi.model.SecurablePrivilegeGrantsRequest;
import ru.cedrusdata.catalog.spi.model.SecurityProviderCreateRequest;
import ru.cedrusdata.catalog.spi.model.SecurityProviderUpdateRequest;

@ResourceType(value=ResourceType.Type.CATALOG)
@ResourceSecurity(value=ResourceSecurity.Type.AUTHENTICATED)
@Path(value="/v1")
public class V1Api {
    private final V1ApiImpl apiImpl;

    @Inject
    public V1Api(V1ApiImpl apiImpl) {
        this.apiImpl = apiImpl;
    }

    @POST
    @Path(value="/object-groups/{object-group}/items")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addObjectGroupItem(@PathParam(value="object-group") String objectGroup, ObjectGroupItemAddRequest objectGroupItemAddRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.addObjectGroupItem(CatalogUtils.getAuthenticationContext(securityContext), objectGroup, objectGroupItemAddRequest);
    }

    @DELETE
    @Path(value="/maintenance/operations/{operation-id}")
    @Produces(value={"application/json"})
    public Response cancelMaintenanceOperation(@PathParam(value="operation-id") UUID operationId, @Context SecurityContext securityContext) {
        return this.apiImpl.cancelMaintenanceOperation(CatalogUtils.getAuthenticationContext(securityContext), operationId);
    }

    @POST
    @Path(value="/security/check-access")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response checkAccess(CheckAccessRequest checkAccessRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.checkAccess(CatalogUtils.getAuthenticationContext(securityContext), checkAccessRequest);
    }

    @GET
    @Path(value="/compute-engines/{compute-engine}/check")
    @Produces(value={"application/json"})
    public Response checkComputeEngine(@PathParam(value="compute-engine") String computeEngine, @Context SecurityContext securityContext) {
        return this.apiImpl.checkComputeEngine(CatalogUtils.getAuthenticationContext(securityContext), computeEngine);
    }

    @GET
    @Path(value="/file-systems/{file-system}/check")
    @Produces(value={"application/json"})
    public Response checkFileSystem(@PathParam(value="file-system") String fileSystem, @Context SecurityContext securityContext) {
        return this.apiImpl.checkFileSystem(CatalogUtils.getAuthenticationContext(securityContext), fileSystem);
    }

    @GET
    @Path(value="/iceberg-catalogs/{iceberg-catalog}/check")
    @Produces(value={"application/json"})
    public Response checkIcebergCatalog(@PathParam(value="iceberg-catalog") String icebergCatalog, @Context SecurityContext securityContext) {
        return this.apiImpl.checkIcebergCatalog(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog);
    }

    @GET
    @Path(value="/security-providers/{security-provider}/check")
    @Produces(value={"application/json"})
    public Response checkSecurityProvider(@PathParam(value="security-provider") String securityProvider, @Context SecurityContext securityContext) {
        return this.apiImpl.checkSecurityProvider(CatalogUtils.getAuthenticationContext(securityContext), securityProvider);
    }

    @POST
    @Path(value="/access-tokens")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createAccessToken(AccessTokenCreateRequest accessTokenCreateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.createAccessToken(CatalogUtils.getAuthenticationContext(securityContext), accessTokenCreateRequest);
    }

    @POST
    @Path(value="/compute-engines")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createComputeEngine(ComputeEngineCreateRequest computeEngineCreateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.createComputeEngine(CatalogUtils.getAuthenticationContext(securityContext), computeEngineCreateRequest);
    }

    @POST
    @Path(value="/file-systems")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createFileSystem(FileSystemCreateRequest fileSystemCreateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.createFileSystem(CatalogUtils.getAuthenticationContext(securityContext), fileSystemCreateRequest);
    }

    @POST
    @Path(value="/iceberg-catalogs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createIcebergCatalog(IcebergCatalogCreateRequest icebergCatalogCreateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.createIcebergCatalog(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalogCreateRequest);
    }

    @POST
    @Path(value="/maintenance/jobs")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createMaintenanceJob(MaintenanceJobCreateRequest maintenanceJobCreateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.createMaintenanceJob(CatalogUtils.getAuthenticationContext(securityContext), maintenanceJobCreateRequest);
    }

    @POST
    @Path(value="/object-groups")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createObjectGroup(ObjectGroupCreateRequest objectGroupCreateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.createObjectGroup(CatalogUtils.getAuthenticationContext(securityContext), objectGroupCreateRequest);
    }

    @POST
    @Path(value="/principals")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createPrincipal(PrincipalCreateRequest principalCreateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.createPrincipal(CatalogUtils.getAuthenticationContext(securityContext), principalCreateRequest);
    }

    @POST
    @Path(value="/security-providers")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createSecurityProvider(SecurityProviderCreateRequest securityProviderCreateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.createSecurityProvider(CatalogUtils.getAuthenticationContext(securityContext), securityProviderCreateRequest);
    }

    @POST
    @Path(value="/access-tokens-temporary/{principal}")
    @Produces(value={"application/json"})
    public Response createTemporaryAccessToken(@PathParam(value="principal") String principal, @Context SecurityContext securityContext) {
        return this.apiImpl.createTemporaryAccessToken(CatalogUtils.getAuthenticationContext(securityContext), principal);
    }

    @POST
    @Path(value="/access-tokens-temporary")
    @Produces(value={"application/json"})
    public Response createTemporaryAccessTokenForSelf(@Context SecurityContext securityContext) {
        return this.apiImpl.createTemporaryAccessTokenForSelf(CatalogUtils.getAuthenticationContext(securityContext));
    }

    @DELETE
    @Path(value="/access-tokens/{access-token-id}")
    @Produces(value={"application/json"})
    public Response deleteAccessToken(@PathParam(value="access-token-id") String accessTokenId, @Context SecurityContext securityContext) {
        return this.apiImpl.deleteAccessToken(CatalogUtils.getAuthenticationContext(securityContext), accessTokenId);
    }

    @DELETE
    @Path(value="/compute-engines/{compute-engine}")
    @Produces(value={"application/json"})
    public Response deleteComputeEngine(@PathParam(value="compute-engine") String computeEngine, @Context SecurityContext securityContext) {
        return this.apiImpl.deleteComputeEngine(CatalogUtils.getAuthenticationContext(securityContext), computeEngine);
    }

    @DELETE
    @Path(value="/file-systems/{file-system}")
    @Produces(value={"application/json"})
    public Response deleteFileSystem(@PathParam(value="file-system") String fileSystem, @Context SecurityContext securityContext) {
        return this.apiImpl.deleteFileSystem(CatalogUtils.getAuthenticationContext(securityContext), fileSystem);
    }

    @DELETE
    @Path(value="/iceberg-catalogs/{iceberg-catalog}")
    @Produces(value={"application/json"})
    public Response deleteIcebergCatalog(@PathParam(value="iceberg-catalog") String icebergCatalog, @Context SecurityContext securityContext) {
        return this.apiImpl.deleteIcebergCatalog(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog);
    }

    @DELETE
    @Path(value="/maintenance/jobs/{job-name}")
    @Produces(value={"application/json"})
    public Response deleteMaintenanceJob(@PathParam(value="job-name") String jobName, @Context SecurityContext securityContext) {
        return this.apiImpl.deleteMaintenanceJob(CatalogUtils.getAuthenticationContext(securityContext), jobName);
    }

    @DELETE
    @Path(value="/object-groups/{object-group}")
    @Produces(value={"application/json"})
    public Response deleteObjectGroup(@PathParam(value="object-group") String objectGroup, @Context SecurityContext securityContext) {
        return this.apiImpl.deleteObjectGroup(CatalogUtils.getAuthenticationContext(securityContext), objectGroup);
    }

    @DELETE
    @Path(value="/object-groups/{object-group}/items/{object-group-item-id}")
    @Produces(value={"application/json"})
    public Response deleteObjectGroupItem(@PathParam(value="object-group") String objectGroup, @PathParam(value="object-group-item-id") UUID objectGroupItemId, @Context SecurityContext securityContext) {
        return this.apiImpl.deleteObjectGroupItem(CatalogUtils.getAuthenticationContext(securityContext), objectGroup, objectGroupItemId);
    }

    @DELETE
    @Path(value="/principals/{principal}")
    @Produces(value={"application/json"})
    public Response deletePrincipal(@PathParam(value="principal") String principal, @Context SecurityContext securityContext) {
        return this.apiImpl.deletePrincipal(CatalogUtils.getAuthenticationContext(securityContext), principal);
    }

    @DELETE
    @Path(value="/security-providers/{security-provider}")
    @Produces(value={"application/json"})
    public Response deleteSecurityProvider(@PathParam(value="security-provider") String securityProvider, @Context SecurityContext securityContext) {
        return this.apiImpl.deleteSecurityProvider(CatalogUtils.getAuthenticationContext(securityContext), securityProvider);
    }

    @GET
    @Path(value="/compute-engines/{compute-engine}")
    @Produces(value={"application/json"})
    public Response getComputeEngine(@PathParam(value="compute-engine") String computeEngine, @Context SecurityContext securityContext) {
        return this.apiImpl.getComputeEngine(CatalogUtils.getAuthenticationContext(securityContext), computeEngine);
    }

    @POST
    @Path(value="/iceberg-catalogs/{iceberg-catalog}/cte-table-for-reuse")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getCteTableForReuse(@PathParam(value="iceberg-catalog") String icebergCatalog, IcebergCteTableForReuseRequest icebergCteTableForReuseRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.getCteTableForReuse(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog, icebergCteTableForReuseRequest);
    }

    @GET
    @Path(value="/file-systems/{file-system}")
    @Produces(value={"application/json"})
    public Response getFileSystem(@PathParam(value="file-system") String fileSystem, @Context SecurityContext securityContext) {
        return this.apiImpl.getFileSystem(CatalogUtils.getAuthenticationContext(securityContext), fileSystem);
    }

    @GET
    @Path(value="/iceberg-catalogs/{iceberg-catalog}")
    @Produces(value={"application/json"})
    public Response getIcebergCatalog(@PathParam(value="iceberg-catalog") String icebergCatalog, @Context SecurityContext securityContext) {
        return this.apiImpl.getIcebergCatalog(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog);
    }

    @GET
    @Path(value="/iceberg-catalogs/{iceberg-catalog}/namespaces/{iceberg-namespace}")
    @Produces(value={"application/json"})
    public Response getIcebergNamespace(@PathParam(value="iceberg-catalog") String icebergCatalog, @PathParam(value="iceberg-namespace") String icebergNamespace, @Context SecurityContext securityContext) {
        return this.apiImpl.getIcebergNamespace(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog, icebergNamespace);
    }

    @GET
    @Path(value="/iceberg-catalogs/{iceberg-catalog}/namespaces/{iceberg-namespace}/objects/{iceberg-object}")
    @Produces(value={"application/json"})
    public Response getIcebergObject(@PathParam(value="iceberg-catalog") String icebergCatalog, @PathParam(value="iceberg-namespace") String icebergNamespace, @PathParam(value="iceberg-object") String icebergObject, @Context SecurityContext securityContext) {
        return this.apiImpl.getIcebergObject(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog, icebergNamespace, icebergObject);
    }

    @GET
    @Path(value="/maintenance/jobs/{job-name}")
    @Produces(value={"application/json"})
    public Response getMaintenanceJob(@PathParam(value="job-name") String jobName, @Context SecurityContext securityContext) {
        return this.apiImpl.getMaintenanceJob(CatalogUtils.getAuthenticationContext(securityContext), jobName);
    }

    @GET
    @Path(value="/maintenance/operations/{operation-id}")
    @Produces(value={"application/json"})
    public Response getMaintenanceOperation(@PathParam(value="operation-id") UUID operationId, @Context SecurityContext securityContext) {
        return this.apiImpl.getMaintenanceOperation(CatalogUtils.getAuthenticationContext(securityContext), operationId);
    }

    @GET
    @Path(value="/object-groups/{object-group}")
    @Produces(value={"application/json"})
    public Response getObjectGroup(@PathParam(value="object-group") String objectGroup, @Context SecurityContext securityContext) {
        return this.apiImpl.getObjectGroup(CatalogUtils.getAuthenticationContext(securityContext), objectGroup);
    }

    @GET
    @Path(value="/principals/{principal}")
    @Produces(value={"application/json"})
    public Response getPrincipal(@PathParam(value="principal") String principal, @Context SecurityContext securityContext) {
        return this.apiImpl.getPrincipal(CatalogUtils.getAuthenticationContext(securityContext), principal);
    }

    @GET
    @Path(value="/security-providers/{security-provider}")
    @Produces(value={"application/json"})
    public Response getSecurityProvider(@PathParam(value="security-provider") String securityProvider, @Context SecurityContext securityContext) {
        return this.apiImpl.getSecurityProvider(CatalogUtils.getAuthenticationContext(securityContext), securityProvider);
    }

    @POST
    @Path(value="/security/grant-ownership")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response grantOwnership(GrantOwnershipRequest grantOwnershipRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.grantOwnership(CatalogUtils.getAuthenticationContext(securityContext), grantOwnershipRequest);
    }

    @POST
    @Path(value="/security/grant-privilege")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response grantPrivilege(GrantPrivilegeRequest grantPrivilegeRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.grantPrivilege(CatalogUtils.getAuthenticationContext(securityContext), grantPrivilegeRequest);
    }

    @POST
    @Path(value="/security/grant-role")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response grantRole(GrantRoleRequest grantRoleRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.grantRole(CatalogUtils.getAuthenticationContext(securityContext), grantRoleRequest);
    }

    @GET
    @Path(value="/access-tokens")
    @Produces(value={"application/json"})
    public Response listAccessTokens(@QueryParam(value="principalName") String principalName, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listAccessTokens(CatalogUtils.getAuthenticationContext(securityContext), principalName, pageToken, pageSize);
    }

    @GET
    @Path(value="/compute-engines")
    @Produces(value={"application/json"})
    public Response listComputeEngines(@QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listComputeEngines(CatalogUtils.getAuthenticationContext(securityContext), pageToken, pageSize);
    }

    @GET
    @Path(value="/file-systems")
    @Produces(value={"application/json"})
    public Response listFileSystems(@QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listFileSystems(CatalogUtils.getAuthenticationContext(securityContext), pageToken, pageSize);
    }

    @GET
    @Path(value="/iceberg-catalogs")
    @Produces(value={"application/json"})
    public Response listIcebergCatalogs(@QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listIcebergCatalogs(CatalogUtils.getAuthenticationContext(securityContext), pageToken, pageSize);
    }

    @GET
    @Path(value="/iceberg-namespaces")
    @Produces(value={"application/json"})
    public Response listIcebergNamespaces(@QueryParam(value="catalog") String catalog, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listIcebergNamespaces(CatalogUtils.getAuthenticationContext(securityContext), catalog, pageToken, pageSize);
    }

    @GET
    @Path(value="/iceberg-objects")
    @Produces(value={"application/json"})
    public Response listIcebergObjects(@QueryParam(value="catalog") String catalog, @QueryParam(value="namespace") String namespace, @QueryParam(value="objectType") String objectType, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listIcebergObjects(CatalogUtils.getAuthenticationContext(securityContext), catalog, namespace, objectType, pageToken, pageSize);
    }

    @GET
    @Path(value="/i18n/labels/{locale}")
    @Produces(value={"application/json"})
    public Response listLabels(@PathParam(value="locale") String locale, @Context SecurityContext securityContext) {
        return this.apiImpl.listLabels(CatalogUtils.getAuthenticationContext(securityContext), locale);
    }

    @GET
    @Path(value="/i18n/locales")
    @Produces(value={"application/json"})
    public Response listLocales(@Context SecurityContext securityContext) {
        return this.apiImpl.listLocales(CatalogUtils.getAuthenticationContext(securityContext));
    }

    @GET
    @Path(value="/maintenance/jobs")
    @Produces(value={"application/json"})
    public Response listMaintenanceJobs(@QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="filter") String filter, @Context SecurityContext securityContext) {
        return this.apiImpl.listMaintenanceJobs(CatalogUtils.getAuthenticationContext(securityContext), pageToken, pageSize, filter);
    }

    @GET
    @Path(value="/maintenance/operations")
    @Produces(value={"application/json"})
    public Response listMaintenanceOperations(@QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="filter") String filter, @Context SecurityContext securityContext) {
        return this.apiImpl.listMaintenanceOperations(CatalogUtils.getAuthenticationContext(securityContext), pageToken, pageSize, filter);
    }

    @POST
    @Path(value="/iceberg-catalogs/{iceberg-catalog}/materialized-views-for-rewrite")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response listMaterializedViewsForRewrite(@PathParam(value="iceberg-catalog") String icebergCatalog, IcebergMaterializedViewForRewriteListRequest icebergMaterializedViewForRewriteListRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.listMaterializedViewsForRewrite(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog, icebergMaterializedViewForRewriteListRequest);
    }

    @GET
    @Path(value="/object-groups/{object-group}/items")
    @Produces(value={"application/json"})
    public Response listObjectGroupItems(@PathParam(value="object-group") String objectGroup, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listObjectGroupItems(CatalogUtils.getAuthenticationContext(securityContext), objectGroup, pageToken, pageSize);
    }

    @GET
    @Path(value="/object-groups/{object-group}/objects")
    @Produces(value={"application/json"})
    public Response listObjectGroupObjects(@PathParam(value="object-group") String objectGroup, @QueryParam(value="itemId") UUID itemId, @QueryParam(value="objectType") String objectType, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listObjectGroupObjects(CatalogUtils.getAuthenticationContext(securityContext), objectGroup, itemId, objectType, pageToken, pageSize);
    }

    @GET
    @Path(value="/object-groups")
    @Produces(value={"application/json"})
    public Response listObjectGroups(@QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listObjectGroups(CatalogUtils.getAuthenticationContext(securityContext), pageToken, pageSize);
    }

    @GET
    @Path(value="/principals")
    @Produces(value={"application/json"})
    public Response listPrincipals(@QueryParam(value="principalType") String principalType, @QueryParam(value="principalActive") Boolean principalActive, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listPrincipals(CatalogUtils.getAuthenticationContext(securityContext), principalType, principalActive, pageToken, pageSize);
    }

    @GET
    @Path(value="/security-providers")
    @Produces(value={"application/json"})
    public Response listSecurityProviders(@QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context SecurityContext securityContext) {
        return this.apiImpl.listSecurityProviders(CatalogUtils.getAuthenticationContext(securityContext), pageToken, pageSize);
    }

    @GET
    @Path(value="/security/principal-privilege-grants/{principal}")
    @Produces(value={"application/json"})
    public Response principalPrivilegeGrants(@PathParam(value="principal") String principal, @Context SecurityContext securityContext) {
        return this.apiImpl.principalPrivilegeGrants(CatalogUtils.getAuthenticationContext(securityContext), principal);
    }

    @GET
    @Path(value="/security/privilege-types")
    @Produces(value={"application/json"})
    public Response privilegeTypes(@Context SecurityContext securityContext) {
        return this.apiImpl.privilegeTypes(CatalogUtils.getAuthenticationContext(securityContext));
    }

    @GET
    @Path(value="/security/privileged-actions")
    @Produces(value={"application/json"})
    public Response privilegedActions(@Context SecurityContext securityContext) {
        return this.apiImpl.privilegedActions(CatalogUtils.getAuthenticationContext(securityContext));
    }

    @POST
    @Path(value="/security/revoke-privilege")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response revokePrivilege(RevokePrivilegeRequest revokePrivilegeRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.revokePrivilege(CatalogUtils.getAuthenticationContext(securityContext), revokePrivilegeRequest);
    }

    @POST
    @Path(value="/security/revoke-role")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response revokeRole(RevokeRoleRequest revokeRoleRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.revokeRole(CatalogUtils.getAuthenticationContext(securityContext), revokeRoleRequest);
    }

    @GET
    @Path(value="/security/role-members/{role}")
    @Produces(value={"application/json"})
    public Response roleMembers(@PathParam(value="role") String role, @Context SecurityContext securityContext) {
        return this.apiImpl.roleMembers(CatalogUtils.getAuthenticationContext(securityContext), role);
    }

    @POST
    @Path(value="/security/securable-privilege-grants")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response securablePrivilegeGrants(SecurablePrivilegeGrantsRequest securablePrivilegeGrantsRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.securablePrivilegeGrants(CatalogUtils.getAuthenticationContext(securityContext), securablePrivilegeGrantsRequest);
    }

    @GET
    @Path(value="/security/securable-types")
    @Produces(value={"application/json"})
    public Response securableTypes(@Context SecurityContext securityContext) {
        return this.apiImpl.securableTypes(CatalogUtils.getAuthenticationContext(securityContext));
    }

    @POST
    @Path(value="/maintenance/operations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response startMaintenanceOperation(MaintenanceOperationStartRequest maintenanceOperationStartRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.startMaintenanceOperation(CatalogUtils.getAuthenticationContext(securityContext), maintenanceOperationStartRequest);
    }

    @POST
    @Path(value="/compute-engines/{compute-engine}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateComputeEngine(@PathParam(value="compute-engine") String computeEngine, ComputeEngineUpdateRequest computeEngineUpdateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.updateComputeEngine(CatalogUtils.getAuthenticationContext(securityContext), computeEngine, computeEngineUpdateRequest);
    }

    @POST
    @Path(value="/file-systems/{file-system}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateFileSystem(@PathParam(value="file-system") String fileSystem, FileSystemUpdateRequest fileSystemUpdateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.updateFileSystem(CatalogUtils.getAuthenticationContext(securityContext), fileSystem, fileSystemUpdateRequest);
    }

    @POST
    @Path(value="/iceberg-catalogs/{iceberg-catalog}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateIcebergCatalog(@PathParam(value="iceberg-catalog") String icebergCatalog, IcebergCatalogUpdateRequest icebergCatalogUpdateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.updateIcebergCatalog(CatalogUtils.getAuthenticationContext(securityContext), icebergCatalog, icebergCatalogUpdateRequest);
    }

    @POST
    @Path(value="/maintenance/jobs/{job-name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateMaintenanceJob(@PathParam(value="job-name") String jobName, MaintenanceJobUpdateRequest maintenanceJobUpdateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.updateMaintenanceJob(CatalogUtils.getAuthenticationContext(securityContext), jobName, maintenanceJobUpdateRequest);
    }

    @POST
    @Path(value="/object-groups/{object-group}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateObjectGroup(@PathParam(value="object-group") String objectGroup, ObjectGroupUpdateRequest objectGroupUpdateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.updateObjectGroup(CatalogUtils.getAuthenticationContext(securityContext), objectGroup, objectGroupUpdateRequest);
    }

    @POST
    @Path(value="/principals/{principal}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updatePrincipal(@PathParam(value="principal") String principal, PrincipalUpdateRequest principalUpdateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.updatePrincipal(CatalogUtils.getAuthenticationContext(securityContext), principal, principalUpdateRequest);
    }

    @POST
    @Path(value="/security-providers/{security-provider}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response updateSecurityProvider(@PathParam(value="security-provider") String securityProvider, SecurityProviderUpdateRequest securityProviderUpdateRequest, @Context SecurityContext securityContext) {
        return this.apiImpl.updateSecurityProvider(CatalogUtils.getAuthenticationContext(securityContext), securityProvider, securityProviderUpdateRequest);
    }
}

