/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.iceberg.rest;

import jakarta.ws.rs.core.HttpHeaders;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import ru.cedrusdata.catalog.spi.exception.CatalogBadRequestException;

public record IcebergOptions(Optional<String> s3AccessKey, Optional<String> s3SecretKey, Optional<Long> asOfTimestamp) {
    public static final IcebergOptions DEFAULT = new IcebergOptions(Optional.empty(), Optional.empty(), Optional.empty());
    private static final String ACCESS_KEY = "access-key";
    private static final String SECRET_KEY = "secret-key";

    public static IcebergOptions createIcebergOptions(HttpHeaders headers) {
        String s3AccessKey = headers.getHeaderString("X-CedrusData-S3-Access-Key-Override");
        String s3SecretKey = headers.getHeaderString("X-CedrusData-S3-Secret-Key-Override");
        if (s3AccessKey != null || s3SecretKey != null) {
            if (s3AccessKey == null || s3AccessKey.trim().isEmpty()) {
                throw new CatalogBadRequestException(String.format("\"%s\" header cannot be empty when at least one of \"%s\" or \"%s\" headers is set", "X-CedrusData-S3-Access-Key-Override", "X-CedrusData-S3-Access-Key-Override", "X-CedrusData-S3-Secret-Key-Override"));
            }
            if (s3SecretKey == null || s3SecretKey.trim().isEmpty()) {
                throw new CatalogBadRequestException(String.format("\"%s\" header cannot be empty when at least one of \"%s\" or \"%s\" headers is set", "X-CedrusData-S3-Secret-Key-Override", "X-CedrusData-S3-Access-Key-Override", "X-CedrusData-S3-Secret-Key-Override"));
            }
            s3AccessKey = s3AccessKey.trim();
            s3SecretKey = s3SecretKey.trim();
        }
        Optional<Long> asOfTimestampMillis = IcebergOptions.parseAsOfTimestamp(headers.getHeaderString("X-CedrusData-As-Of-Timestamp"));
        return new IcebergOptions(Optional.ofNullable(s3AccessKey), Optional.ofNullable(s3SecretKey), asOfTimestampMillis);
    }

    public Map<String, String> toMap() {
        HashMap<String, String> res = new HashMap<String, String>();
        if (this.s3AccessKey.isPresent()) {
            res.put(ACCESS_KEY, this.s3AccessKey.get());
        }
        if (this.s3SecretKey.isPresent()) {
            res.put(SECRET_KEY, this.s3SecretKey.get());
        }
        return res;
    }

    private static Optional<Long> parseAsOfTimestamp(String valueString) {
        if (valueString == null) {
            return Optional.empty();
        }
        try {
            long value = Long.parseLong(valueString);
            if (value < 0L) {
                throw new CatalogBadRequestException(String.format("\"%s\" header value cannot be negative", "X-CedrusData-As-Of-Timestamp"));
            }
            return Optional.of(value);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Optional.of(ZonedDateTime.parse(valueString).toInstant().toEpochMilli());
            }
            catch (Exception exception) {
                try {
                    return Optional.of(OffsetDateTime.parse(valueString).toInstant().toEpochMilli());
                }
                catch (Exception exception2) {
                    throw new CatalogBadRequestException(String.format("Cannot parse \"%s\" header value \"%s\"", "X-CedrusData-As-Of-Timestamp", valueString));
                }
            }
        }
    }
}

