/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization.securable;

import ru.cedrusdata.catalog.core.security.authorization.securable.InternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.MetastoreInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableCollector;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableItem;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;

public record NamespaceInternalSecurable(SecurableItem catalog, SecurableItem namespace) implements InternalSecurable
{
    @Override
    public SecurableType type() {
        return SecurableType.SECURABLE_TYPE_NAMESPACE;
    }

    @Override
    public SecurableItem resolve(SecurableType type) {
        return switch (type) {
            case SecurableType.SECURABLE_TYPE_METASTORE -> MetastoreInternalSecurable.METASTORE_SECURABLE_ITEM;
            case SecurableType.SECURABLE_TYPE_CATALOG -> this.catalog;
            case SecurableType.SECURABLE_TYPE_NAMESPACE -> this.namespace;
            default -> throw new IllegalArgumentException("Unexpected component type " + String.valueOf((Object)type) + " for securable " + String.valueOf((Object)this.type()));
        };
    }

    @Override
    public void collect(SecurableCollector collector) {
        collector.collect(SecurableType.SECURABLE_TYPE_METASTORE, MetastoreInternalSecurable.METASTORE_SECURABLE_ITEM);
        collector.collect(SecurableType.SECURABLE_TYPE_CATALOG, this.catalog);
        collector.collect(SecurableType.SECURABLE_TYPE_NAMESPACE, this.namespace);
    }
}

