/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization.check;

import java.util.List;
import java.util.UUID;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheck;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckContext;
import ru.cedrusdata.catalog.core.security.authorization.check.AuthorizationCheckResultStep;
import ru.cedrusdata.catalog.core.security.authorization.securable.InternalSecurable;

public class AuthorizationPredefinedRoleCheck
implements AuthorizationCheck {
    private final String roleName;

    AuthorizationPredefinedRoleCheck(String roleName) {
        this.roleName = roleName;
    }

    @Override
    public AuthorizationCheck prepare(InternalSecurable securable) {
        return this;
    }

    @Override
    public AuthorizationCheckResultStep check(AuthorizationCheckContext context) {
        UUID roleId = context.predefinedRoleIds().resolve(this.roleName);
        boolean result = context.principal().roleIds().contains(roleId);
        return new AuthorizationCheckResultStep(this, result, List.of());
    }

    @Override
    public String descriptor(InternalSecurable securable) {
        return this.toString();
    }

    public String toString() {
        return "role(" + this.roleName + ")";
    }
}

