/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.security.authorization;

import java.util.Optional;
import ru.cedrusdata.catalog.core.security.authorization.CatalogPrivilegedAction;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;
import ru.cedrusdata.catalog.iceberg.table.IcebergTableType;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;

public enum AuthorizerObjectType {
    TABLE(IcebergTableType.TABLE, SecurableType.SECURABLE_TYPE_TABLE, CatalogPrivilegedAction.ACTION_TABLE_CREATE, CatalogPrivilegedAction.ACTION_TABLE_ALTER, CatalogPrivilegedAction.ACTION_TABLE_DROP, CatalogPrivilegedAction.ACTION_TABLE_DESCRIBE, Optional.of(CatalogPrivilegedAction.ACTION_TABLE_MODIFY)),
    VIEW(IcebergTableType.VIEW, SecurableType.SECURABLE_TYPE_VIEW, CatalogPrivilegedAction.ACTION_VIEW_CREATE, CatalogPrivilegedAction.ACTION_VIEW_ALTER, CatalogPrivilegedAction.ACTION_VIEW_DROP, CatalogPrivilegedAction.ACTION_VIEW_DESCRIBE, Optional.empty()),
    MATERIALIZED_VIEW(IcebergTableType.TABLE, SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW, CatalogPrivilegedAction.ACTION_MATERIALIZED_VIEW_CREATE, CatalogPrivilegedAction.ACTION_MATERIALIZED_VIEW_ALTER, CatalogPrivilegedAction.ACTION_MATERIALIZED_VIEW_DROP, CatalogPrivilegedAction.ACTION_MATERIALIZED_VIEW_DESCRIBE, Optional.of(CatalogPrivilegedAction.ACTION_MATERIALIZED_VIEW_MODIFY));

    private final IcebergTableType physicalType;
    private final SecurableType securableType;
    private final CatalogPrivilegedAction createAction;
    private final CatalogPrivilegedAction alterAction;
    private final CatalogPrivilegedAction dropAction;
    private final CatalogPrivilegedAction usageAction;
    private final Optional<CatalogPrivilegedAction> modifyAction;

    private AuthorizerObjectType(IcebergTableType physicalType, SecurableType securableType, CatalogPrivilegedAction createAction, CatalogPrivilegedAction alterAction, CatalogPrivilegedAction dropAction, CatalogPrivilegedAction usageAction, Optional<CatalogPrivilegedAction> modifyAction) {
        this.physicalType = physicalType;
        this.securableType = securableType;
        this.createAction = createAction;
        this.alterAction = alterAction;
        this.dropAction = dropAction;
        this.usageAction = usageAction;
        this.modifyAction = modifyAction;
    }

    public IcebergTableType physicalType() {
        return this.physicalType;
    }

    public SecurableType securableType() {
        return this.securableType;
    }

    public CatalogPrivilegedAction createAction() {
        return this.createAction;
    }

    public CatalogPrivilegedAction alterAction() {
        return this.alterAction;
    }

    public CatalogPrivilegedAction dropAction() {
        return this.dropAction;
    }

    public CatalogPrivilegedAction usageAction() {
        return this.usageAction;
    }

    public CatalogPrivilegedAction modifyAction() {
        return this.modifyAction.orElseThrow(() -> new CatalogInternalServerErrorException("Data modification operations are not supported for " + String.valueOf((Object)this)));
    }

    public static AuthorizerObjectType fromSecurableType(SecurableType securableType) {
        return switch (securableType) {
            case SecurableType.SECURABLE_TYPE_TABLE -> TABLE;
            case SecurableType.SECURABLE_TYPE_VIEW -> VIEW;
            case SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW -> MATERIALIZED_VIEW;
            default -> throw new CatalogInternalServerErrorException("Unexpected securable type for object operation authorization: " + String.valueOf((Object)securableType));
        };
    }
}

