/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.maintenance;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.model.time.ExecutionTime;
import com.cronutils.parser.CronParser;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import ru.cedrusdata.catalog.core.maintenance.ScheduleExecutionTime;

@FunctionalInterface
interface ScheduleTimeResolver {
    public static final CronDefinition CRON_DEFINITION = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX);

    public ScheduleExecutionTime nextExecutionTime(long var1);

    public static ScheduleTimeResolver createCronResolver(String schedule, ZoneId zoneId) {
        Cron cron = new CronParser(CRON_DEFINITION).parse(schedule);
        return now -> {
            ZonedDateTime time = ZonedDateTime.ofInstant(Instant.ofEpochMilli(now), zoneId);
            long timeToNextExecution = ((Duration)ExecutionTime.forCron((Cron)cron).timeToNextExecution(time).orElseThrow()).toMillis();
            return new ScheduleExecutionTime(now + timeToNextExecution, timeToNextExecution);
        };
    }
}

