/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.filesystem;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import ru.cedrusdata.catalog.core.security.authorization.securable.FileSystemInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableItem;
import ru.cedrusdata.catalog.plugin.ExtensionPropertyClassifier;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystemType;
import ru.cedrusdata.catalog.spi.model.FileSystemInfo;

public record FileSystemDetails(UUID id, String name, Optional<UUID> ownerId, Optional<String> ownerName, String description, CatalogFileSystemType type, Map<String, String> properties) {
    public FileSystemInfo toInfo(ExtensionPropertyClassifier<CatalogFileSystemType> propertyClassifier) {
        ImmutableMap.Builder finalProperties = ImmutableMap.builder();
        ImmutableSet.Builder finalRedactedProperties = ImmutableSet.builder();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            if (propertyClassifier.shouldRedact(this.type, key)) {
                finalRedactedProperties.add((Object)key);
                continue;
            }
            finalProperties.put((Object)key, (Object)entry.getValue());
        }
        return new FileSystemInfo(this.name, this.type.name(), (String)this.ownerName.orElse(null), this.description, (Map)finalProperties.buildOrThrow(), (Set)finalRedactedProperties.build());
    }

    public FileSystemInternalSecurable toSecurable() {
        return new FileSystemInternalSecurable(new SecurableItem(this.id, this.ownerId, this.name));
    }
}

