/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.computeengine.local;

import com.google.common.annotations.VisibleForTesting;
import io.airlift.log.Logger;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import ru.cedrusdata.catalog.spi.filesystem.CatalogFileSystem;

public class BatchDelete
implements Consumer<String> {
    private static final Logger logger = Logger.get(BatchDelete.class);
    @VisibleForTesting
    public static final int DELETE_BATCH_SIZE = 1000;
    private static final int DELETE_FILES_MESSAGE_LIMIT = 5;
    private final CatalogFileSystem fileSystem;
    private final boolean throwOnError;
    private final List<String> filesToDelete = new ArrayList<String>();
    private int deletedCount;
    private RuntimeException deleteError;

    public BatchDelete(CatalogFileSystem fileSystem, boolean throwOnError) {
        this.fileSystem = fileSystem;
        this.throwOnError = throwOnError;
    }

    @Override
    public void accept(String filePath) {
        if (this.deleteError != null) {
            return;
        }
        this.filesToDelete.add(filePath);
        if (this.filesToDelete.size() >= 1000) {
            this.deleteFiles();
        }
    }

    public int finish() {
        if (this.deleteError == null) {
            this.deleteFiles();
        }
        return this.deletedCount;
    }

    public RuntimeException deleteError() {
        return this.deleteError;
    }

    private void deleteFiles() {
        block3: {
            try {
                if (this.filesToDelete.isEmpty()) {
                    return;
                }
                this.fileSystem.deleteFiles(this.filesToDelete);
                this.deletedCount += this.filesToDelete.size();
                this.filesToDelete.clear();
            }
            catch (IOException e) {
                String errorMessage = "Failed to delete some or all files: " + this.filesToDelete.stream().limit(5L).collect(Collectors.joining(", ")) + (this.filesToDelete.size() > 5 ? String.format(",... (total %d files)", this.filesToDelete.size()) : "");
                logger.error((Throwable)e, errorMessage);
                this.deleteError = new UncheckedIOException(errorMessage, e);
                if (!this.throwOnError) break block3;
                throw this.deleteError;
            }
        }
    }
}

