/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.core.computeengine;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import ru.cedrusdata.catalog.core.computeengine.local.LocalComputeEngine;
import ru.cedrusdata.catalog.spi.CatalogPluginContext;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngine;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineProvider;
import ru.cedrusdata.catalog.spi.computeengine.CatalogComputeEngineType;
import ru.cedrusdata.catalog.spi.model.ComputeEngineOperationMetadata;
import ru.cedrusdata.catalog.spi.model.ComputeEngineOperationParameterType;

public class InternalComputeEngineProvider
implements CatalogComputeEngineProvider {
    private final LocalComputeEngine engine;
    private final Map<Locale, ResourceBundle> labelBundles;

    @Inject
    public InternalComputeEngineProvider(LocalComputeEngine engine) {
        this.engine = engine;
        ImmutableMap.Builder labelBundlesBuilder = ImmutableMap.builder();
        for (Locale locale : List.of(Locale.ENGLISH, Locale.forLanguageTag("ru"))) {
            labelBundlesBuilder.put((Object)locale, (Object)ResourceBundle.getBundle("i18n/LocalEngineOperationMetadataBundle", locale));
        }
        this.labelBundles = labelBundlesBuilder.buildOrThrow();
    }

    public List<ComputeEngineOperationMetadata> supportedOperations() {
        ResourceBundle resourceBundle = this.labelBundles.get(Locale.ENGLISH);
        String engineType = CatalogComputeEngineType.LOCAL.name().toLowerCase(Locale.ROOT);
        return List.of(CatalogComputeEngineProvider.operationMetadata((ResourceBundle)resourceBundle, (String)engineType, (String)"expire-snapshots", Map.of("older-than", ComputeEngineOperationParameterType.INT, "retain-last", ComputeEngineOperationParameterType.INT)), CatalogComputeEngineProvider.operationMetadata((ResourceBundle)resourceBundle, (String)engineType, (String)"remove-orphan-files", Map.of("older-than", ComputeEngineOperationParameterType.INT)));
    }

    public Map<Locale, ResourceBundle> labels() {
        return this.labelBundles;
    }

    public CatalogComputeEngineType getComputeEngineType() {
        return CatalogComputeEngineType.LOCAL;
    }

    public CatalogComputeEngine createComputeEngine(CatalogPluginContext context, Map<String, String> config) {
        return this.engine;
    }
}

