/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.config.store;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;

public class CatalogStoreConfig {
    private Type storeType = Type.SQLITE;
    private int storeMaxPageSize = 10000;

    @NotNull
    public Type getStoreType() {
        return this.storeType;
    }

    @Config(value="store.type")
    @ConfigDescription(value="Catalog store type. Allowed values: SQLITE, POSTGRESQL")
    public CatalogStoreConfig setStoreType(Type storeType) {
        this.storeType = storeType;
        return this;
    }

    @Min(value=1L)
    @Max(value=65536L)
    public @Min(value=1L) @Max(value=65536L) int getStoreMaxPageSize() {
        return this.storeMaxPageSize;
    }

    @Config(value="store.max-page-size")
    @ConfigDescription(value="Maximum page size for list operations (zero or negative value makes make page size infinite)")
    public CatalogStoreConfig setStoreMaxPageSize(int storeMaxPageSize) {
        this.storeMaxPageSize = storeMaxPageSize;
        return this;
    }

    public static enum Type {
        SQLITE,
        POSTGRESQL;

    }
}

