/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.config.store;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.Duration;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.concurrent.TimeUnit;

public class CatalogJdbcStoreConfig {
    private int storeJdbcConnectionPoolSize = Math.min(64, Runtime.getRuntime().availableProcessors() * 4);
    private Duration storeJdbcConnectionPoolTtl = Duration.succinctDuration((double)5.0, (TimeUnit)TimeUnit.MINUTES);

    @Min(value=0L)
    public @Min(value=0L) int getStoreJdbcConnectionPoolSize() {
        return this.storeJdbcConnectionPoolSize;
    }

    @Config(value="store.jdbc-connection-pool.size")
    @ConfigDescription(value="Maximum number of connections in the JDBC connection pool")
    public CatalogJdbcStoreConfig setStoreJdbcConnectionPoolSize(int storeJdbcConnectionPoolSize) {
        this.storeJdbcConnectionPoolSize = storeJdbcConnectionPoolSize;
        return this;
    }

    @NotNull
    public Duration getStoreJdbcConnectionPoolTtl() {
        return this.storeJdbcConnectionPoolTtl;
    }

    @Config(value="store.jdbc-connection-pool.ttl")
    @ConfigDescription(value="TTl for pooled JDBC connections")
    public CatalogJdbcStoreConfig setStoreJdbcConnectionPoolTtl(Duration storeJdbcConnectionPoolTtl) {
        this.storeJdbcConnectionPoolTtl = storeJdbcConnectionPoolTtl;
        return this;
    }
}

