/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import io.airlift.http.server.HttpServerConfig;
import io.airlift.http.server.HttpsConfig;
import io.airlift.node.NodeConfig;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Min;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class CatalogServerConfig {
    public static final String ENVIRONMENT = "cedrusdata_catalog";
    private String serverBindIp;
    private boolean serverHttpEnabled = true;
    private int serverHttpPort = 9080;
    private boolean serverHttpProcessForwarded;
    private boolean serverHttpsEnabled;
    private int serverHttpsPort = 9443;
    private File serverHttpsKeystorePath;
    private String serverHttpsKeystorePassword;
    private String serverHttpsKeymanagerPassword;
    private File serverHttpsTruststorePath;
    private String serverHttpsTruststorePassword;
    private List<String> serverHttpsIncludedCipherSuites = ImmutableList.of();
    private List<String> serverHttpsExcludedCipherSuites = ImmutableList.copyOf((Object[])new SslContextFactory.Server().getExcludeCipherSuites());
    private Duration serverHttpsSessionTimeout = new Duration(4.0, TimeUnit.HOURS);
    private int serverHttpsSessionCacheSize = 10000;
    private Duration serverHttpsContextRefreshTime = new Duration(1.0, TimeUnit.MINUTES);

    public String getServerBindIp() {
        return this.serverBindIp;
    }

    @Config(value="server.bind-ip")
    @ConfigDescription(value="The IP address the server should use when binding a server socket (defaults to any local address)")
    public CatalogServerConfig setServerBindIp(String serverBindIp) {
        this.serverBindIp = serverBindIp;
        return this;
    }

    public boolean isServerHttpEnabled() {
        return this.serverHttpEnabled;
    }

    @Config(value="server.http.enabled")
    @ConfigDescription(value="Whether HTTP endpoint is enabled")
    public CatalogServerConfig setServerHttpEnabled(boolean serverHttpEnabled) {
        this.serverHttpEnabled = serverHttpEnabled;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getServerHttpPort() {
        return this.serverHttpPort;
    }

    @Config(value="server.http.port")
    @ConfigDescription(value="Port for communication over insecure HTTP")
    public CatalogServerConfig setServerHttpPort(int serverHttpPort) {
        this.serverHttpPort = serverHttpPort;
        return this;
    }

    public boolean isServerHttpProcessForwarded() {
        return this.serverHttpProcessForwarded;
    }

    @Config(value="server.http.process-forwarded")
    @ConfigDescription(value="Whether to allow forwarded HTTPS requests over HTTP")
    public CatalogServerConfig setServerHttpProcessForwarded(boolean serverHttpProcessForwarded) {
        this.serverHttpProcessForwarded = serverHttpProcessForwarded;
        return this;
    }

    public boolean isServerHttpsEnabled() {
        return this.serverHttpsEnabled;
    }

    @Config(value="server.https.enabled")
    @ConfigDescription(value="Whether SSL endpoint is enabled")
    public CatalogServerConfig setServerHttpsEnabled(boolean serverHttpsEnabled) {
        this.serverHttpsEnabled = serverHttpsEnabled;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getServerHttpsPort() {
        return this.serverHttpsPort;
    }

    @Config(value="server.https.port")
    @ConfigDescription(value="Port for communication over HTTPS")
    public CatalogServerConfig setServerHttpsPort(int httpPorts) {
        this.serverHttpsPort = httpPorts;
        return this;
    }

    public Optional<@FileExists File> getServerHttpsKeystorePath() {
        return Optional.ofNullable(this.serverHttpsKeystorePath);
    }

    @Config(value="server.https.keystore-path")
    @ConfigDescription(value="Path to the PEM or Java keystore file. Mandatory when SSL is enabled")
    public CatalogServerConfig setServerHttpsKeystorePath(File serverHttpsKeystorePath) {
        this.serverHttpsKeystorePath = serverHttpsKeystorePath;
        return this;
    }

    @AssertTrue(message="\"server.https.keystore-path\" must be provided when HTTPS is enabled")
    public @AssertTrue(message="\"server.https.keystore-path\" must be provided when HTTPS is enabled") boolean isServerHttpsKeystoreSet() {
        return !this.isServerHttpsEnabled() || this.getServerHttpsKeystorePath().isPresent();
    }

    public String getServerHttpsKeystorePassword() {
        return this.serverHttpsKeystorePassword;
    }

    @Config(value="server.https.keystore-password")
    @ConfigDescription(value="Optional keystore password")
    @ConfigSecuritySensitive
    public CatalogServerConfig setServerHttpsKeystorePassword(String serverHttpsKeystorePassword) {
        this.serverHttpsKeystorePassword = serverHttpsKeystorePassword;
        return this;
    }

    public String getServerHttpsKeymanagerPassword() {
        return this.serverHttpsKeymanagerPassword;
    }

    @Config(value="server.https.keymanager-password")
    @ConfigDescription(value="Password for a key within a keystore, when a different password is configured for the specific key")
    @ConfigSecuritySensitive
    public CatalogServerConfig setServerHttpsKeymanagerPassword(String serverHttpsKeymanagerPassword) {
        this.serverHttpsKeymanagerPassword = serverHttpsKeymanagerPassword;
        return this;
    }

    public Optional<@FileExists File> getServerHttpsTruststorePath() {
        return Optional.ofNullable(this.serverHttpsTruststorePath);
    }

    @Config(value="server.https.truststore-path")
    @ConfigDescription(value="Path to the optional PEM or Java truststore file")
    public CatalogServerConfig setServerHttpsTruststorePath(File serverHttpsTruststorePath) {
        this.serverHttpsTruststorePath = serverHttpsTruststorePath;
        return this;
    }

    public String getServerHttpsTruststorePassword() {
        return this.serverHttpsTruststorePassword;
    }

    @Config(value="server.https.truststore-password")
    @ConfigDescription(value="Optional truststore password")
    @ConfigSecuritySensitive
    public CatalogServerConfig setServerHttpsTruststorePassword(String serverHttpsTruststorePassword) {
        this.serverHttpsTruststorePassword = serverHttpsTruststorePassword;
        return this;
    }

    public String getServerHttpsIncludedCipherSuites() {
        return String.join((CharSequence)",", this.serverHttpsIncludedCipherSuites);
    }

    @Config(value="server.https.included-cipher-suites")
    @ConfigDescription(value="Included cipher suites")
    public CatalogServerConfig setServerHttpsIncludedCipherSuites(String serverHttpsIncludedCipherSuites) {
        this.serverHttpsIncludedCipherSuites = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)Objects.requireNonNull(serverHttpsIncludedCipherSuites, "sslIncludedCipherSuites is null"));
        return this;
    }

    public String getServerHttpsExcludedCipherSuites() {
        return String.join((CharSequence)",", this.serverHttpsExcludedCipherSuites);
    }

    @Config(value="server.https.excluded-cipher-suites")
    @ConfigDescription(value="Excluded cipher suites")
    public CatalogServerConfig setServerHttpsExcludedCipherSuites(String serverHttpsExcludedCipherSuites) {
        this.serverHttpsExcludedCipherSuites = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)Objects.requireNonNull(serverHttpsExcludedCipherSuites, "sslExcludedCipherSuites is null"));
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getServerHttpsSessionTimeout() {
        return this.serverHttpsSessionTimeout;
    }

    @Config(value="server.https.session-timeout")
    @ConfigDescription(value="Duration of a valid TLS client session")
    public CatalogServerConfig setServerHttpsSessionTimeout(Duration serverHttpsSessionTimeout) {
        this.serverHttpsSessionTimeout = serverHttpsSessionTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getServerHttpsSessionCacheSize() {
        return this.serverHttpsSessionCacheSize;
    }

    @Config(value="server.https.session-cache-size")
    @ConfigDescription(value="Maximum number of SSL session cache entries")
    public CatalogServerConfig setServerHttpsSessionCacheSize(int serverHttpsSessionCacheSize) {
        this.serverHttpsSessionCacheSize = serverHttpsSessionCacheSize;
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getServerHttpsContextRefreshTime() {
        return this.serverHttpsContextRefreshTime;
    }

    @Config(value="server.https.context-refresh-time")
    @ConfigDescription(value="Time between reloading default certificates")
    public CatalogServerConfig setServerHttpsContextRefreshTime(Duration serverHttpsContextRefreshTime) {
        this.serverHttpsContextRefreshTime = serverHttpsContextRefreshTime;
        return this;
    }

    public NodeConfig toAirliftNodeConfig() {
        NodeConfig config = new NodeConfig().setEnvironment(ENVIRONMENT);
        if (this.getServerBindIp() != null) {
            config.setNodeBindIp(this.getServerBindIp());
        }
        return config;
    }

    public HttpServerConfig toAirliftHttpConfig() {
        return new HttpServerConfig().setHttpEnabled(this.isServerHttpEnabled()).setHttpsEnabled(this.isServerHttpsEnabled()).setHttpPort(this.getServerHttpPort()).setProcessForwarded(this.isServerHttpProcessForwarded() ? HttpServerConfig.ProcessForwardedMode.ACCEPT : HttpServerConfig.ProcessForwardedMode.REJECT).setLogPath("var/log/catalog-http-request.log");
    }

    public Optional<HttpsConfig> toAirliftHttpsConfig() {
        if (!this.isServerHttpsEnabled()) {
            return Optional.empty();
        }
        return Optional.of(new HttpsConfig().setHttpsPort(this.getServerHttpsPort()).setKeystorePath((String)this.getServerHttpsKeystorePath().map(File::toString).orElse(null)).setKeystorePassword(this.getServerHttpsKeystorePassword()).setKeyManagerPassword(this.getServerHttpsKeymanagerPassword()).setTrustStorePath((String)this.getServerHttpsTruststorePath().map(File::toString).orElse(null)).setTrustStorePassword(this.getServerHttpsTruststorePassword()).setHttpsIncludedCipherSuites(this.getServerHttpsIncludedCipherSuites()).setHttpsExcludedCipherSuites(this.getServerHttpsExcludedCipherSuites()).setSslSessionTimeout(this.getServerHttpsSessionTimeout()).setSslSessionCacheSize(this.getServerHttpsSessionCacheSize()).setSslContextRefreshTime(this.getServerHttpsContextRefreshTime()));
    }
}

