/*
 * Decompiled with CFR 0.152.
 */
package ru.cedrusdata.catalog.config;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import jakarta.validation.constraints.NotNull;

public class CatalogCacheConfig {
    private DataSize cachePrincipalSize = DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private Duration cachePrincipalTtl = Duration.valueOf((String)"1d");
    private DataSize cacheIcebergTableMetadataSize = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private Duration cacheIcebergTableMetadataTtl = Duration.valueOf((String)"1d");

    @NotNull
    public DataSize getCachePrincipalSize() {
        return this.cachePrincipalSize;
    }

    @Config(value="cache.principal.size")
    @ConfigDescription(value="Principal cache size in bytes")
    public CatalogCacheConfig setCachePrincipalSize(DataSize cachePrincipalSize) {
        this.cachePrincipalSize = cachePrincipalSize;
        return this;
    }

    @NotNull
    public Duration getCachePrincipalTtl() {
        return this.cachePrincipalTtl;
    }

    @Config(value="cache.principal.ttl")
    @ConfigDescription(value="Principal cache TTL")
    public CatalogCacheConfig setCachePrincipalTtl(Duration cachePrincipalTtl) {
        this.cachePrincipalTtl = cachePrincipalTtl;
        return this;
    }

    @NotNull
    public DataSize getCacheIcebergTableMetadataSize() {
        return this.cacheIcebergTableMetadataSize;
    }

    @Config(value="cache.iceberg-table-metadata.size")
    @ConfigDescription(value="Iceberg object metadata cache size in bytes")
    public CatalogCacheConfig setCacheIcebergTableMetadataSize(DataSize cacheIcebergTableMetadataSize) {
        this.cacheIcebergTableMetadataSize = cacheIcebergTableMetadataSize;
        return this;
    }

    @NotNull
    public Duration getCacheIcebergTableMetadataTtl() {
        return this.cacheIcebergTableMetadataTtl;
    }

    @Config(value="cache.iceberg-table-metadata.ttl")
    @ConfigDescription(value="Iceberg object metadata cache TTL")
    public CatalogCacheConfig setCacheIcebergTableMetadataTtl(Duration cacheIcebergTableMetadataTtl) {
        this.cacheIcebergTableMetadataTtl = cacheIcebergTableMetadataTtl;
        return this;
    }
}

