/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.TableMetadata;
import ru.cedrusdata.catalog.core.principal.AuthenticatedPrincipal;
import ru.cedrusdata.catalog.core.security.authorization.Authorizer;
import ru.cedrusdata.catalog.core.security.authorization.securable.ObjectInternalSecurable;
import ru.cedrusdata.catalog.core.security.authorization.securable.SecurableType;
import ru.cedrusdata.catalog.spi.exception.CatalogInternalServerErrorException;

public enum TableUpdateType {
    ALTER(Authorizer::authorizeObjectAlter),
    MODIFY(Authorizer::authorizeObjectModify);

    private static final Map<Class<? extends MetadataUpdate>, TableUpdateType> CLASS_TO_TYPE;
    private final AuthorizationAction authorizationAction;

    private TableUpdateType(AuthorizationAction authorizationAction) {
        this.authorizationAction = authorizationAction;
    }

    public void authorize(Authorizer authorizer, AuthenticatedPrincipal principal, ObjectInternalSecurable securable) {
        Verify.verify((securable.type() == SecurableType.SECURABLE_TYPE_TABLE || securable.type() == SecurableType.SECURABLE_TYPE_MATERIALIZED_VIEW ? 1 : 0) != 0, (String)("Unexpected securable type: " + String.valueOf((Object)securable.type())), (Object[])new Object[0]);
        this.authorizationAction.authorize(authorizer, principal, securable);
    }

    public static SortedSet<TableUpdateType> determineUpdateType(TableMetadata metadata) {
        TreeSet<TableUpdateType> res = new TreeSet<TableUpdateType>();
        for (MetadataUpdate update : metadata.changes()) {
            TableUpdateType updateType = TableUpdateType.determineUpdateType(update.getClass());
            res.add(updateType);
        }
        return res;
    }

    @VisibleForTesting
    public static TableUpdateType determineUpdateType(Class<? extends MetadataUpdate> clazz) {
        TableUpdateType type = CLASS_TO_TYPE.get(clazz);
        if (type != null) {
            return type;
        }
        throw new CatalogInternalServerErrorException("Unsupported table metadata update: " + clazz.getSimpleName());
    }

    static {
        CLASS_TO_TYPE = ImmutableMap.builder().put(MetadataUpdate.AddPartitionSpec.class, (Object)ALTER).put(MetadataUpdate.AddSchema.class, (Object)ALTER).put(MetadataUpdate.AddSortOrder.class, (Object)ALTER).put(MetadataUpdate.SetCurrentSchema.class, (Object)ALTER).put(MetadataUpdate.SetDefaultPartitionSpec.class, (Object)ALTER).put(MetadataUpdate.SetDefaultSortOrder.class, (Object)ALTER).put(MetadataUpdate.SetLocation.class, (Object)ALTER).put(MetadataUpdate.SetProperties.class, (Object)ALTER).put(MetadataUpdate.UpgradeFormatVersion.class, (Object)ALTER).put(MetadataUpdate.RemoveProperties.class, (Object)ALTER).put(MetadataUpdate.AddSnapshot.class, (Object)MODIFY).put(MetadataUpdate.RemoveSnapshot.class, (Object)MODIFY).put(MetadataUpdate.SetSnapshotRef.class, (Object)MODIFY).put(MetadataUpdate.RemoveSnapshotRef.class, (Object)MODIFY).put(MetadataUpdate.SetStatistics.class, (Object)MODIFY).put(MetadataUpdate.SetPartitionStatistics.class, (Object)MODIFY).put(MetadataUpdate.RemovePartitionStatistics.class, (Object)MODIFY).put(MetadataUpdate.RemoveStatistics.class, (Object)MODIFY).buildOrThrow();
    }

    @FunctionalInterface
    private static interface AuthorizationAction {
        public void authorize(Authorizer var1, AuthenticatedPrincipal var2, ObjectInternalSecurable var3);
    }
}

