/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import io.airlift.http.client.jetty.HttpClientLogger;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.transport.HttpRequest;

class HttpClientLoggingListener
implements Response.Listener,
Request.Listener {
    private final HttpClientLogger logger;
    private final long requestTimestampMillis;
    private final HttpRequest request;
    private long contentSize;
    private final long requestCreatedTimestamp = System.nanoTime();
    private long requestBeginTimestamp;
    private long requestEndTimestamp;
    private long responseBeginTimestamp;
    private long responseCompleteTimestamp;

    HttpClientLoggingListener(HttpRequest request, long requestTimestampMillis, HttpClientLogger logger) {
        this.request = Objects.requireNonNull(request, "request is null");
        this.requestTimestampMillis = requestTimestampMillis;
        this.logger = Objects.requireNonNull(logger, "logger is null");
    }

    public void onBegin(Request request) {
        this.requestBeginTimestamp = System.nanoTime();
    }

    public void onContent(Request request, ByteBuffer content) {
        this.contentSize += (long)content.remaining();
    }

    public void onFailure(Request request, Throwable failure) {
        this.requestEndTimestamp = System.nanoTime();
    }

    public void onSuccess(Request request) {
        this.requestEndTimestamp = System.nanoTime();
    }

    public void onBegin(Response response) {
        this.responseBeginTimestamp = System.nanoTime();
    }

    public void onComplete(Result result) {
        this.responseCompleteTimestamp = System.nanoTime();
        this.logRequestResponse(result);
    }

    private void logRequestResponse(Result result) {
        HttpClientLogger.RequestInfo requestInfo = HttpClientLogger.RequestInfo.from((Request)this.request, this.requestTimestampMillis, this.requestCreatedTimestamp, this.requestBeginTimestamp, this.requestEndTimestamp);
        Throwable throwable = result.getFailure();
        HttpClientLogger.ResponseInfo responseInfo = throwable != null ? HttpClientLogger.ResponseInfo.failed(Optional.of(result.getResponse()), Optional.of(throwable), this.responseBeginTimestamp, this.responseCompleteTimestamp) : HttpClientLogger.ResponseInfo.from(Optional.of(result.getResponse()), this.contentSize, this.responseBeginTimestamp, this.responseCompleteTimestamp);
        this.logger.log(requestInfo, responseInfo);
    }
}

